/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.text.VariantFormatter;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.view.TextFieldView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class TextFieldControl
extends TextFieldView
implements Serializable,
ColumnAware,
BlackBox,
WritableSingletonModel,
AccessListener,
DataChangeListener {
    private boolean addNotifyCalled = false;
    private String columnName;
    private DataSet dataSet;

    public void enableModelEvents(boolean bl) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(bl);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void set(Object object) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(object);
        }
    }

    public Object get() {
        return this.getModel().get();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() != 401 || keyEvent.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (keyEvent.getKeyCode()) {
                case 155: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.insertRow(false);
                    break;
                }
                case 127: {
                    if (keyEvent.isControlDown()) {
                        this.dataSet.deleteRow();
                    }
                    break;
                }
                case 34: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        if (color != null) {
            ((Component)this).setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        if (!this.formatData().equals(this.getText())) {
            this.postText();
        }
    }

    private String formatData() {
        Column column;
        String string = "";
        if (this.model != null && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            Object object = this.model.get();
            if (object != null) {
                VariantFormatter variantFormatter = column.getFormatter();
                if (variantFormatter != null) {
                    try {
                        string = variantFormatter.format(object);
                    }
                    catch (Exception exception) {
                        DataSetModel.handleException(this.dataSet, this, exception);
                    }
                } else {
                    string = object.toString();
                }
            }
        } else {
            string = this.getText();
        }
        return string;
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void postText() {
        VariantFormatter variantFormatter;
        Column column;
        if (this.canSet(true) && !this.locateOnly && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (variantFormatter = column.getFormatter()) != null) {
            String string = super.getText();
            Object object = null;
            try {
                object = variantFormatter.parse(string);
            }
            catch (Exception exception) {
                DataSetModel.handleException(this.dataSet, this, exception);
                return;
            }
            try {
                this.writeModel.set(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.postText();
    }

    public void setText(String string) {
        VariantFormatter variantFormatter;
        Column column;
        if (this.canSet(true) && !this.locateOnly && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (variantFormatter = column.getFormatter()) != null) {
            Object object = null;
            try {
                object = variantFormatter.parse(string);
            }
            catch (Exception exception) {
                DataSetModel.handleException(this.dataSet, this, exception);
                return;
            }
            try {
                this.writeModel.set(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.setText(string);
    }

    protected void updateText() {
        VariantFormatter variantFormatter;
        Column column;
        if (this.model != null && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (variantFormatter = column.getFormatter()) != null) {
            Object object = this.model.get();
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            String string = "";
            try {
                string = variantFormatter.format(object);
            }
            catch (Exception exception) {
                DataSetModel.handleException(this.dataSet, this, exception);
                return;
            }
            this.setSuperText(string != null ? string : "");
            this.setSelectionStart(n);
            this.setSelectionEnd(n2);
            return;
        }
        super.updateText();
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(76));
        }
        super.setModel(singletonModel);
    }

    public TextFieldControl() {
        this.setModel(new BasicSingletonContainer());
    }
}

