/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.Variant;
import com.borland.jbcl.control.GridControl;
import com.borland.jbcl.control.LookupDialog;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class PopupPickListItemEditor
implements Serializable,
ItemEditor {
    transient RowFilterListener listener;
    boolean displayOKCancel = false;
    boolean alwaysCenter = false;
    boolean allowSearch = true;
    String windowTitle = "";
    LookupDialog lookupDialog;
    GridControl gridControl;
    Variant value = new Variant();
    int[] columnDialogState;
    int[] columnOriginalState;
    DataRow locateRow;
    DataSet targetDataSet;
    DataSetView pickListDataSet;
    String[] displayColumns;
    Column[] pickListColumns;
    String[] targetColumns;
    String[] sourceColumns;
    String currentColumnName;

    public void removeKeyListener(KeyListener keyListener) {
    }

    public void addKeyListener(KeyListener keyListener) {
    }

    public void endEdit(boolean bl) {
    }

    public boolean canPost() {
        return true;
    }

    public void changeBounds(Rectangle rectangle) {
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        Column column = null;
        ColumnVariant columnVariant = null;
        if (object instanceof ColumnVariant) {
            columnVariant = (ColumnVariant)object;
            this.value.setVariant((Variant)columnVariant);
            column = columnVariant.getColumn();
            this.currentColumnName = column.getColumnName();
            this.targetDataSet = columnVariant.getDataSet();
            if (this.pickListDataSet == null || !this.pickListDataSet.isCompatibleList((ReadRow)this.locateRow)) {
                this.loadPickList(column.getPickList(), itemEditSite.getSiteComponent());
            }
            if (this.pickListDataSet == null) {
                itemEditSite.safeEndEdit(false);
                return;
            }
            if (this.listener != null) {
                try {
                    this.pickListDataSet.refilter();
                }
                catch (DataSetException dataSetException) {
                    DataSetModel.handleException(this.gridControl, (Exception)((Object)dataSetException), true);
                }
            }
        }
        if (this.pickListDataSet != null && this.locateRow != null) {
            try {
                columnVariant.getDataSet();
                ReadRow.copyTo((String[])this.targetColumns, (ReadRow)columnVariant.getDataSet(), (String[])this.sourceColumns, (ReadWriteRow)this.locateRow);
                this.pickListDataSet.locate((ReadRow)this.locateRow, 32);
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.gridControl, (Exception)((Object)dataSetException), true);
            }
        }
        try {
            int n;
            for (n = 0; n < this.pickListColumns.length; ++n) {
                this.pickListColumns[n].setVisible(this.columnDialogState[n]);
            }
            this.lookupDialog.show();
            for (n = 0; n < this.pickListColumns.length; ++n) {
                this.pickListColumns[n].setVisible(this.columnOriginalState[n]);
            }
        }
        catch (DataSetException dataSetException) {
            DataSetModel.handleException(this.gridControl, (Exception)((Object)dataSetException), true);
        }
        itemEditSite.safeEndEdit(this.lookupDialog.useValue());
    }

    public Component getComponent() {
        return null;
    }

    public Object getValue() {
        if (this.pickListDataSet != null && this.lookupDialog != null && !this.lookupDialog.useValue()) {
            return this.value;
        }
        return this.pickListDataSet;
    }

    protected void loadPickList(PickListDescriptor pickListDescriptor, Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int n;
            this.pickListDataSet = new DataSetView();
            if (this.listener != null) {
                if (this.pickListDataSet.getRowFilterListener() != null) {
                    this.pickListDataSet.removeRowFilterListener(this.pickListDataSet.getRowFilterListener());
                }
                this.pickListDataSet.addRowFilterListener(this.listener);
            }
            this.pickListDataSet.setStorageDataSet(pickListDescriptor.getPickListDataSet().getStorageDataSet());
            this.sourceColumns = pickListDescriptor.getPickListColumns();
            this.targetColumns = pickListDescriptor.getDestinationColumns();
            this.displayColumns = pickListDescriptor.getPickListDisplayColumns();
            if (this.sourceColumns == null || this.sourceColumns.length == 0 || this.targetColumns == null || this.targetColumns.length == 0 || this.displayColumns == null || this.displayColumns.length == 0) {
                this.pickListDataSet = null;
                component.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.pickListDataSet.open();
            this.locateRow = new DataRow((DataSet)this.pickListDataSet, this.sourceColumns);
            this.pickListColumns = pickListDescriptor.getPickListDataSet().getStorageDataSet().getColumns();
            this.columnOriginalState = new int[this.pickListColumns.length];
            this.columnDialogState = new int[this.pickListColumns.length];
            for (n = 0; n < this.pickListColumns.length; ++n) {
                this.columnOriginalState[n] = this.pickListColumns[n].getVisible();
                this.pickListColumns[n].setVisible(0);
            }
            for (n = 0; n < this.displayColumns.length; ++n) {
                pickListDescriptor.getPickListDataSet().getStorageDataSet().getColumn(this.displayColumns[n]).setVisible(1);
            }
            for (n = 0; n < this.pickListColumns.length; ++n) {
                this.columnDialogState[n] = this.pickListColumns[n].getVisible();
            }
            this.gridControl.setDataSet((DataSet)this.pickListDataSet);
            this.gridControl.setReadOnly(true);
            this.gridControl.setMultiSelect(false);
            this.gridControl.setRowHeaderVisible(false);
            this.gridControl.setNavigateOnEnter(false);
            Frame frame = null;
            Component component2 = component;
            while ((component2 = component2.getParent()) != null) {
                if (!(component2 instanceof Frame)) continue;
                frame = (Frame)component2;
                break;
            }
            if (frame == null) {
                frame = new Frame();
            }
            this.lookupDialog = new LookupDialog(frame, this.gridControl, this.allowSearch, this.alwaysCenter, this.displayOKCancel);
            this.lookupDialog.setTitle(this.windowTitle);
        }
        catch (Exception exception) {
            this.pickListDataSet = null;
            DataSetModel.handleException(component, exception, true);
        }
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public final boolean isDisplayOKCancel() {
        return this.displayOKCancel;
    }

    public final void setDisplayOKCancel(boolean bl) {
        if (this.lookupDialog != null) {
            this.lookupDialog.setDisplayOKCancel(bl);
        }
        this.displayOKCancel = bl;
    }

    public final void removeRowFilterListener(RowFilterListener rowFilterListener) {
        this.listener = null;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.removeRowFilterListener(rowFilterListener);
        }
    }

    public final void addRowFilterListener(RowFilterListener rowFilterListener) throws TooManyListenersException {
        if (rowFilterListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = rowFilterListener;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.addRowFilterListener(rowFilterListener);
        }
    }

    public final boolean isAlwaysCenter() {
        return this.alwaysCenter;
    }

    public final void setAlwaysCenter(boolean bl) {
        if (this.lookupDialog != null) {
            this.lookupDialog.setAlwaysCenter(bl);
        }
        this.alwaysCenter = bl;
    }

    public final boolean isAllowSearch() {
        return this.allowSearch;
    }

    public final void setAllowSearch(boolean bl) {
        if (this.lookupDialog != null) {
            this.lookupDialog.setAllowSearch(bl);
        }
        this.allowSearch = bl;
    }

    public final String getTitle() {
        return this.windowTitle;
    }

    public final void setTitle(String string) {
        this.windowTitle = string;
    }

    public PopupPickListItemEditor() {
        this.gridControl = new GridControl();
    }
}

