/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StatusEvent;
import com.borland.dx.dataset.StatusListener;
import com.borland.jbcl.control.ButtonBar;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.util.BlackBox;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class NavigatorControl
extends ButtonBar
implements Serializable,
BlackBox,
DataSetAware,
StatusListener,
NavigationListener,
ActionListener,
AccessListener {
    private boolean addNotifyCalled;
    private DataSet boundDataSet;
    private DataSet dataSet;
    public static final String REFRESH;
    public static final String SAVE;
    public static final String DITTO;
    public static final String CANCEL;
    public static final String POST;
    public static final String DELETE;
    public static final String INSERT;
    public static final String LAST;
    public static final String NEXT;
    public static final String PRIOR;
    public static final String FIRST;

    static {
        FIRST = Res.getString(23);
        PRIOR = Res.getString(24);
        NEXT = Res.getString(25);
        LAST = Res.getString(26);
        INSERT = Res.getString(27);
        DELETE = Res.getString(28);
        POST = Res.getString(29);
        CANCEL = Res.getString(6);
        DITTO = Res.getString(30);
        SAVE = Res.getString(31);
        REFRESH = Res.getString(32);
    }

    private void updateSelection() {
        if (this.boundDataSet != null) {
            try {
                this.setButtonEnabled(FIRST, !this.boundDataSet.atFirst() && !this.boundDataSet.isEmpty());
                this.setButtonEnabled(PRIOR, !this.boundDataSet.atFirst() && !this.boundDataSet.isEmpty());
                this.setButtonEnabled(NEXT, !this.boundDataSet.atLast() || !this.boundDataSet.isEditingNewRow());
                this.setButtonEnabled(LAST, !this.boundDataSet.atLast() && !this.boundDataSet.isEmpty());
                this.setButtonEnabled(INSERT, this.boundDataSet.isEnableInsert());
                this.setButtonEnabled(DELETE, !this.boundDataSet.isEmpty() && this.boundDataSet.isEnableDelete());
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateSelection();
    }

    public void statusMessage(StatusEvent statusEvent) {
        if (this.boundDataSet != null) {
            try {
                switch (statusEvent.getCode()) {
                    case 8: 
                    case 11: 
                    case 12: {
                        this.setButtonEnabled(INSERT, !this.boundDataSet.isEditingNewRow() && this.boundDataSet.isEnableInsert());
                        this.setButtonEnabled(DELETE, !this.boundDataSet.isEmpty() && this.boundDataSet.isEnableDelete());
                        this.setButtonEnabled(POST, this.boundDataSet.isEditing());
                        this.setButtonEnabled(CANCEL, this.boundDataSet.isEditing());
                        this.setButtonEnabled(DITTO, this.boundDataSet.isEditingNewRow());
                    }
                }
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block22: {
            if (this.boundDataSet != null) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (FIRST.equals(string)) {
                        this.boundDataSet.first();
                        break block22;
                    }
                    if (NEXT.equals(string)) {
                        if (this.boundDataSet.atLast()) {
                            this.boundDataSet.insertRow(false);
                        } else {
                            this.boundDataSet.next();
                        }
                        break block22;
                    }
                    if (PRIOR.equals(string)) {
                        this.boundDataSet.prior();
                        break block22;
                    }
                    if (LAST.equals(string)) {
                        this.boundDataSet.last();
                        break block22;
                    }
                    if (INSERT.equals(string)) {
                        this.boundDataSet.insertRow(true);
                        break block22;
                    }
                    if (DELETE.equals(string)) {
                        this.boundDataSet.deleteRow();
                        break block22;
                    }
                    if (POST.equals(string)) {
                        this.boundDataSet.post();
                        break block22;
                    }
                    if (DITTO.equals(string)) {
                        this.boundDataSet.dittoRow(false);
                        break block22;
                    }
                    if (CANCEL.equals(string)) {
                        if (this.boundDataSet.isEditing()) {
                            this.boundDataSet.cancel();
                        } else {
                            this.boundDataSet.cancelLoading();
                        }
                        break block22;
                    }
                    if (SAVE.equals(string) && this.dataSet != null) {
                        try {
                            this.dataSet.saveChanges();
                        }
                        catch (Exception exception) {
                            DataSetModel.handleException(this.dataSet, this, exception);
                        }
                        break block22;
                    }
                    if (REFRESH.equals(string) && this.dataSet != null) {
                        try {
                            this.dataSet.refresh();
                        }
                        catch (Exception exception) {
                            DataSetModel.handleException(this.dataSet, this, exception);
                        }
                        break block22;
                    }
                    return;
                }
                catch (DataSetException dataSetException) {
                    DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                }
            }
        }
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                this.boundDataSet = null;
                break;
            }
        }
    }

    protected void rebuild() {
        if (!this.addNotifyCalled) {
            this.needsRebuild = true;
        }
        super.rebuild();
        if (this.dataSet != null) {
            this.setButtonEnabled(INSERT, this.dataSet.isEnableInsert());
        } else {
            this.setButtonEnabled(FIRST, false);
            this.setButtonEnabled(PRIOR, false);
            this.setButtonEnabled(NEXT, false);
            this.setButtonEnabled(LAST, false);
            this.setButtonEnabled(INSERT, false);
            this.setButtonEnabled(DELETE, false);
            this.setButtonEnabled(POST, false);
            this.setButtonEnabled(CANCEL, false);
            this.setButtonEnabled(DITTO, false);
            this.setButtonEnabled(SAVE, false);
            this.setButtonEnabled(REFRESH, false);
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.rebuild();
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.boundDataSet = this.dataSet;
            this.setButtonEnabled(SAVE, this.boundDataSet.saveChangesSupported());
            this.setButtonEnabled(REFRESH, this.boundDataSet.refreshSupported());
            this.updateSelection();
        }
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeNavigationListener((NavigationListener)this);
            this.dataSet.removeStatusListener((StatusListener)this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addNavigationListener((NavigationListener)this);
            this.dataSet.addStatusListener((StatusListener)this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setLabels(String[] stringArray) {
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width == 100) {
            dimension.width = 275;
        }
        if (dimension.height == 100) {
            dimension.height = 26;
        }
        return dimension;
    }

    public NavigatorControl() {
        super.setBevelInner(0);
        super.setBevelOuter(0);
        super.setLayout(new GridLayout(1, 0));
        super.setMargins(new Insets(0, 0, 0, 0));
        super.setButtonType(2);
        super.setLabels(new String[]{FIRST, PRIOR, NEXT, LAST, INSERT, DELETE, POST, CANCEL, DITTO, SAVE, REFRESH});
        super.setImageNames(new String[]{"image/first.gif", "image/prior.gif", "image/next.gif", "image/last.gif", "image/insert.gif", "image/delete.gif", "image/post.gif", "image/cancel.gif", "image/ditto.gif", "image/save.gif", "image/refresh.gif"});
        this.addActionListener(this);
    }
}

