/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.BlackBox;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelComboBox
extends JComboBox
implements BlackBox {
    boolean changingItem = false;
    protected UIManager.LookAndFeelInfo[] lafi = UIManager.getInstalledLookAndFeels();

    protected void selectedItemChanged() {
        super.selectedItemChanged();
        if (this.changingItem) {
            return;
        }
        int n = this.getSelectedIndex();
        if (n >= 0 && n < this.lafi.length) {
            try {
                UIManager.setLookAndFeel(this.lafi[n].getClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.changingItem = true;
                this.setSelectedItem(UIManager.getLookAndFeel().getName());
                this.changingItem = false;
                return;
            }
            SwingUtilities.updateComponentTreeUI(this.findTopParent());
        }
    }

    protected Component findTopParent() {
        Container container = this;
        Container container2 = this.getParent();
        while (container2 != null) {
            container = container2;
            container2 = container.getParent();
        }
        return container;
    }

    public void updateUI() {
        super.updateUI();
        this.changingItem = true;
        this.setSelectedItem(UIManager.getLookAndFeel().getName());
        this.changingItem = false;
    }

    public void addNotify() {
        super.addNotify();
        this.lafi = UIManager.getInstalledLookAndFeels();
        this.removeAllItems();
        this.changingItem = true;
        for (int i = 0; i < this.lafi.length; ++i) {
            this.addItem(this.lafi[i].getName());
        }
        this.setSelectedItem(UIManager.getLookAndFeel().getName());
        this.changingItem = false;
    }

    public LookAndFeelComboBox() {
        this.setEditable(false);
        this.changingItem = true;
        for (int i = 0; i < this.lafi.length; ++i) {
            this.addItem(this.lafi[i].getName());
        }
        this.changingItem = false;
    }
}

