/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.view.LabelView;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class LabelControl
extends LabelView
implements Serializable,
ColumnAware,
AccessListener,
DataChangeListener {
    private boolean addNotifyCalled = false;
    private String columnName;
    private DataSet dataSet;

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        if (color != null) {
            this.setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && this.dataSet.isOpen() && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.updateText();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        this.updateText();
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public LabelControl(String string) {
        this.setModel(new BasicSingletonContainer());
    }

    public LabelControl() {
        this.setModel(new BasicSingletonContainer());
    }
}

