/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.jbcl.control.ColorChooser;
import com.borland.jbcl.control.FontChooser;
import com.borland.jbcl.control.GridControl;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.StringInput;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.view.ColumnView;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;

class GridControl_PopupSupport
extends MouseAdapter
implements Serializable,
KeyListener,
ActionListener {
    private Font popupFont;
    private boolean alive = true;
    private MatrixLocation hit;
    private GridControl grid;
    private PopupMenu pop = new PopupMenu();
    public static final String FONT;
    public static final String FOREGROUND;
    public static final String BACKGROUND;
    public static final String DELETECOLUMN;
    public static final String INSERTCOLUMN;
    public static final String DELETEROW;
    public static final String INSERTROW;
    public static final String CANCELROW;
    public static final String POST;
    public static final String SORT;
    public static final String VSTRETCH;
    public static final String BOTTOM;
    public static final String MIDDLE;
    public static final String TOP;
    public static final String HSTRETCH;
    public static final String CENTER;
    public static final String RIGHT;
    public static final String LEFT;
    public static final String ALIGNMENT;
    public static final String CAPTION;

    static {
        CAPTION = Res.getString(46);
        ALIGNMENT = Res.getString(47);
        LEFT = Res.getString(48);
        RIGHT = Res.getString(49);
        CENTER = Res.getString(50);
        HSTRETCH = Res.getString(51);
        TOP = Res.getString(52);
        MIDDLE = Res.getString(53);
        BOTTOM = Res.getString(54);
        VSTRETCH = Res.getString(55);
        SORT = Res.getString(56);
        POST = Res.getString(57);
        CANCELROW = Res.getString(58);
        INSERTROW = Res.getString(59);
        DELETEROW = Res.getString(60);
        INSERTCOLUMN = Res.getString(61);
        DELETECOLUMN = Res.getString(62);
        BACKGROUND = Res.getString(63);
        FOREGROUND = Res.getString(64);
        FONT = Res.getString(65);
    }

    String chooseString(String string, String string2) {
        Frame frame = this.findFrame();
        if (frame == null) {
            return null;
        }
        String string3 = string2;
        StringInput stringInput = new StringInput(frame, string, string2);
        stringInput.setValue(string2);
        stringInput.show();
        this.grid.requestFocus();
        if (stringInput.getResult() == 1) {
            return stringInput.getValue();
        }
        return string3;
    }

    Font chooseFont(String string, Font font) {
        Frame frame = this.findFrame();
        if (frame == null) {
            return null;
        }
        Font font2 = font;
        FontChooser fontChooser = new FontChooser(frame, string, font);
        fontChooser.setValue(font);
        fontChooser.show();
        this.grid.requestFocus();
        if (fontChooser.getResult() == 1) {
            return fontChooser.getValue();
        }
        return font2;
    }

    Color chooseColor(String string, Color color) {
        Frame frame = this.findFrame();
        if (frame == null) {
            return null;
        }
        Color color2 = color;
        ColorChooser colorChooser = new ColorChooser(frame, string, color);
        colorChooser.setValue(color);
        colorChooser.show();
        this.grid.requestFocus();
        if (colorChooser.getResult() == 1) {
            return colorChooser.getValue();
        }
        return color2;
    }

    Frame findFrame() {
        Container container;
        for (container = this.grid; container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DataSet dataSet = this.grid.getDataSet();
        ColumnView columnView = this.hit != null ? this.grid.getColumnView(this.hit.column) : null;
        String string = actionEvent.getActionCommand();
        int n = columnView.getAlignment();
        if (string == LEFT) {
            n &= 0xFFFFFFF0;
            columnView.setAlignment(n |= 1);
        } else if (string == CENTER) {
            n &= 0xFFFFFFF0;
            columnView.setAlignment(n |= 2);
        } else if (string == RIGHT) {
            n &= 0xFFFFFFF0;
            columnView.setAlignment(n |= 3);
        } else if (string == HSTRETCH) {
            n &= 0xFFFFFFF0;
            columnView.setAlignment(n |= 4);
        } else if (string == TOP) {
            n &= 0xFFFFFF0F;
            columnView.setAlignment(n |= 0x10);
        } else if (string == MIDDLE) {
            n &= 0xFFFFFF0F;
            columnView.setAlignment(n |= 0x20);
        } else if (string == BOTTOM) {
            n &= 0xFFFFFF0F;
            columnView.setAlignment(n |= 0x30);
        } else if (string == VSTRETCH) {
            n &= 0xFFFFFF0F;
            columnView.setAlignment(n |= 0x40);
        } else if (string == SORT) {
            this.grid.toggleColumnSort(this.hit.column);
        } else if (string == CAPTION) {
            columnView.setCaption(this.chooseString(Res.getString(66), columnView.getCaption()));
        } else if (string == BACKGROUND) {
            columnView.setBackground(this.chooseColor(Res.getString(67), columnView.getBackground()));
        } else if (string == FOREGROUND) {
            columnView.setForeground(this.chooseColor(Res.getString(68), columnView.getForeground()));
        } else if (string == FONT) {
            columnView.setFont(this.chooseFont(Res.getString(69), columnView.getFont()));
        } else if (string == CANCELROW) {
            if (dataSet != null) {
                try {
                    dataSet.cancel();
                }
                catch (DataSetException dataSetException) {}
            }
        } else if (string == POST) {
            if (dataSet != null) {
                try {
                    dataSet.post();
                }
                catch (DataSetException dataSetException) {}
            }
        } else if (string == INSERTROW) {
            if (dataSet != null) {
                try {
                    dataSet.insertRow(true);
                }
                catch (DataSetException dataSetException) {}
            } else if (this.grid.isVariableRows()) {
                if (this.hit != null) {
                    this.grid.addRow(this.hit.row);
                } else {
                    this.grid.addRow();
                }
            }
        } else if (string == DELETEROW) {
            if (dataSet != null) {
                try {
                    dataSet.deleteRow();
                }
                catch (DataSetException dataSetException) {}
            } else if (this.grid.isVariableRows()) {
                this.grid.removeRow(this.hit.row);
            }
        } else if (string == INSERTCOLUMN) {
            if (this.grid.isVariableColumns()) {
                if (this.hit != null) {
                    this.grid.addColumn(this.hit.column);
                } else {
                    this.grid.addColumn();
                }
            }
        } else if (string == DELETECOLUMN && this.grid.isVariableColumns()) {
            this.grid.removeColumn(this.hit.column);
        }
    }

    void itemInspected(int n, int n2) {
        if (this.grid.getColumnCount() == 0) {
            return;
        }
        this.hit = this.grid.getSubfocus();
        this.popupFont = this.grid.getFont();
        this.pop.setFont(this.popupFont);
        this.pop.removeAll();
        boolean bl = false;
        DataSet dataSet = this.grid.getDataSet();
        if (this.hit != null) {
            String string;
            ColumnView columnView = this.grid.getColumnView(this.hit.column);
            String string2 = string = columnView != null ? columnView.getCaption() : null;
            if (string == null) {
                string = Res.format(17, new String[]{String.valueOf(this.hit.column)});
            }
            int n3 = dataSet != null ? dataSet.getRow() + 1 : this.hit.row;
            this.addPopupItem(this.pop, Res.format(45, new String[]{string, String.valueOf(n3)}));
            this.pop.addSeparator();
            this.addPopupItem(this.pop, CAPTION);
            this.addPopupItem(this.pop, BACKGROUND);
            this.addPopupItem(this.pop, FOREGROUND);
            this.addPopupItem(this.pop, FONT);
            Menu menu = new Menu(ALIGNMENT);
            menu.setFont(this.popupFont);
            this.addPopupItem(menu, LEFT);
            this.addPopupItem(menu, CENTER);
            this.addPopupItem(menu, RIGHT);
            this.addPopupItem(menu, HSTRETCH);
            menu.addSeparator();
            this.addPopupItem(menu, TOP);
            this.addPopupItem(menu, MIDDLE);
            this.addPopupItem(menu, BOTTOM);
            this.addPopupItem(menu, VSTRETCH);
            this.pop.add(menu);
            menu.addActionListener(this);
        } else {
            bl = true;
        }
        if (dataSet != null) {
            if (this.hit != null && this.grid.isSortOnHeaderClick() && this.grid.getRowCount() > 0) {
                if (!bl) {
                    this.pop.addSeparator();
                    bl = true;
                }
                this.addPopupItem(this.pop, SORT);
            }
            if (dataSet.isEditing() && !this.grid.isReadOnly()) {
                if (!bl) {
                    this.pop.addSeparator();
                    bl = true;
                }
                this.addPopupItem(this.pop, POST);
                this.addPopupItem(this.pop, CANCELROW);
            }
            if (!dataSet.isEditingNewRow() && !this.grid.isReadOnly() && (dataSet.isEnableInsert() || dataSet.isEnableDelete())) {
                if (!bl) {
                    this.pop.addSeparator();
                    bl = true;
                }
                if (dataSet.isEnableInsert()) {
                    this.addPopupItem(this.pop, INSERTROW);
                }
                if (dataSet.isEnableDelete()) {
                    this.addPopupItem(this.pop, DELETEROW);
                }
            }
        } else {
            if (this.grid.isVariableRows()) {
                if (!bl) {
                    this.pop.addSeparator();
                    bl = true;
                }
                this.addPopupItem(this.pop, INSERTROW);
                if (this.hit != null) {
                    this.addPopupItem(this.pop, DELETEROW);
                }
            }
            if (this.grid.isVariableColumns()) {
                if (!bl) {
                    this.pop.addSeparator();
                    bl = true;
                }
                this.addPopupItem(this.pop, INSERTCOLUMN);
                if (this.hit != null) {
                    this.addPopupItem(this.pop, DELETECOLUMN);
                }
            }
        }
        this.pop.show(this.grid.getCoreComponent(), n, n2);
    }

    private void addPopupItem(Menu menu, String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setFont(menu.getFont());
        menu.add(menuItem);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed() || keyEvent.isControlDown()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isAltDown();
        if ((n == 121 && bl && !bl2 || n == 10 && bl2 && !bl) && this.alive) {
            Rectangle rectangle = this.grid.getCellRect(this.grid.getSubfocus());
            this.itemInspected(rectangle.x + rectangle.width, rectangle.y);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.alive) {
            this.itemInspected(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean bl) {
        this.alive = bl;
    }

    public GridControl_PopupSupport(GridControl gridControl) {
        this.popupFont = new Font("dialog", 0, 12);
        this.grid = gridControl;
        this.pop.addActionListener(this);
        gridControl.getCoreComponent().add(this.pop);
    }
}

