/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FieldView;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class FieldControl
extends FieldView
implements Serializable,
ColumnAware,
BlackBox,
WritableSingletonModel,
AccessListener,
DataChangeListener {
    protected String textureName;
    protected boolean addNotifyCalled = false;
    protected String columnName;
    protected DataSet dataSet;

    public void enableModelEvents(boolean bl) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(bl);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void set(Object object) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(object);
        }
    }

    public boolean canSet(boolean bl) {
        return this.getWriteModel() != null ? this.getWriteModel().canSet(bl) : false;
    }

    public Object get() {
        return this.getModel().get();
    }

    private void setDefaultLayout() {
        this.setModel(new BasicSingletonContainer());
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter(this.getAlignment()))), new TextItemEditor(this.getAlignment())));
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        super.processKeyPressed(keyEvent);
        if (keyEvent.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (keyEvent.getKeyCode()) {
                case 155: {
                    this.dataSet.insertRow(false);
                    break;
                }
                case 127: {
                    if (keyEvent.isControlDown()) {
                        this.dataSet.deleteRow();
                    }
                    break;
                }
                case 34: {
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.endEdit();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        int n = column.getAlignment();
        if (color != null) {
            this.setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
        if (n != 0) {
            this.setAlignment(n);
        }
    }

    private void bindDataSet() {
        Column column;
        this.safeEndEdit(false);
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            SingletonDataSetManager singletonDataSetManager = new SingletonDataSetManager(this.dataSet, column, this);
            this.setModel(singletonDataSetManager);
            this.setViewManager(singletonDataSetManager);
            this.bindProperties(column);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setDefaultLayout();
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                this.setDefaultLayout();
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                this.safeEndEdit(false);
                this.setDefaultLayout();
                break;
            }
        }
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(76));
        }
        super.setModel(singletonModel);
    }

    public synchronized void setText(String string) {
        if (this.canSet(true)) {
            this.set(string);
        }
    }

    public synchronized String getText() {
        Object object = this.get();
        return object != null ? object.toString() : "";
    }

    public FieldControl() {
        this.setDefaultLayout();
    }
}

