/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ImageLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.SystemColor;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

public class DecoratedFrame
extends Frame
implements Serializable {
    protected URL url;
    protected String imageName;
    protected boolean disposeOnClose = true;
    protected boolean exitOnClose = true;
    protected Component client;

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        MenuBar menuBar = this.getMenuBar();
        if (menuBar != null) {
            Font font = menuBar.getFont();
            FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : null;
            int n = fontMetrics != null ? fontMetrics.getHeight() : 0;
            dimension.height += n;
        }
        return dimension;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201 && this.disposeOnClose) {
            this.dispose();
        } else if (windowEvent.getID() == 202 && this.exitOnClose && !Beans.isDesignTime()) {
            System.exit(0);
        }
    }

    protected void setupImage(Image image, String string) throws IOException {
        this.prepareImage(image, this);
        if ((this.checkImage(image, this) & 0x40) != 0) {
            throw new IOException(Res.format(22, new String[]{string}));
        }
        this.imageName = string;
        super.setIconImage(image);
    }

    public URL getIconImageURL() {
        return this.url;
    }

    public void setIconImageURL(URL uRL) throws IOException {
        this.url = uRL;
        this.setupImage(ImageLoader.load(uRL, (Component)this), uRL.toString());
    }

    public void setIconImage(Image image) {
        try {
            this.setupImage(image, "");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
    }

    public String getIconImageName() {
        return this.imageName;
    }

    public void setIconImageName(String string) throws IOException {
        if (string != null && !string.equals("")) {
            this.setupImage(ImageLoader.load(string, (Component)this), string);
        } else {
            this.imageName = null;
            super.setIconImage(null);
        }
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean bl) {
        this.exitOnClose = bl;
    }

    public boolean isDisposeOnClose() {
        return this.disposeOnClose;
    }

    public void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
    }

    public void setClient(Component component) {
        if (this.client != null) {
            this.remove(this.client);
        }
        this.client = component;
        super.add(this.client, "Center");
        Dimension dimension = component.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            int n = dimension.width + this.getInsets().left + this.getInsets().right;
            int n2 = dimension.height + this.getInsets().top + this.getInsets().bottom;
            ((Component)this).setSize(n, n2);
        }
    }

    public Component getClient() {
        return this.client;
    }

    public DecoratedFrame() {
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(SystemColor.control);
        this.enableEvents(64L);
    }
}

