/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.FocusMulticaster;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.ItemMulticaster;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.util.MouseMulticaster;
import com.objectspace.jgl.Array;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class CheckboxPanel
extends BevelPanel
implements Serializable,
BlackBox {
    protected String textureName;
    private transient MouseMulticaster mouseMulticaster;
    private transient KeyMulticaster keyMulticaster;
    private transient FocusMulticaster focusMulticaster;
    private transient ItemMulticaster itemMulticaster;
    private GridLayout gridLayout = new GridLayout();
    private String groupSelectedLabel;
    private int groupSelectedIndex = -1;
    private CheckboxGroup group;
    private int orientation = 0;

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseMulticaster.remove(mouseListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseMulticaster.add(mouseListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemMulticaster.remove(itemListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemMulticaster.add(itemListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyMulticaster.remove(keyListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyMulticaster.add(keyListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.focusMulticaster.remove(focusListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.focusMulticaster == null) {
            super.addFocusListener(focusListener);
        } else {
            this.focusMulticaster.add(focusListener);
        }
    }

    public String getSelectedLabel() {
        Checkbox checkbox;
        if (this.group != null && (checkbox = this.group.getSelectedCheckbox()) != null) {
            return checkbox.getLabel();
        }
        return null;
    }

    public void setSelectedLabel(String string) {
        if (this.group != null) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Checkbox checkbox = (Checkbox)this.getComponent(i);
                if (!checkbox.getLabel().equals(string)) continue;
                this.group.setSelectedCheckbox(checkbox);
                return;
            }
        } else {
            this.groupSelectedLabel = string;
        }
    }

    public int getSelectedIndex() {
        if (this.group != null) {
            Checkbox checkbox = this.group.getSelectedCheckbox();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (this.getComponent(i) != checkbox) continue;
                return i;
            }
        }
        return -1;
    }

    public void setSelectedIndex(int n) {
        if (this.group != null) {
            this.group.setSelectedCheckbox((Checkbox)this.getComponent(n));
        } else {
            this.groupSelectedIndex = n;
        }
    }

    public String getLabel(int n) {
        return ((Checkbox)this.getComponent(n)).getLabel();
    }

    public void addLabel(String string) {
        Checkbox checkbox = new Checkbox(string, false, this.group);
        checkbox.addItemListener(this.itemMulticaster);
        checkbox.addFocusListener(this.focusMulticaster);
        checkbox.addKeyListener(this.keyMulticaster);
        checkbox.addMouseListener(this.mouseMulticaster);
        checkbox.setEnabled(this.isEnabled());
        this.add(checkbox);
        this.repaint(100L);
    }

    public void setLabel(int n, String string) {
        ((Checkbox)this.getComponent(n)).setLabel(string);
    }

    public String[] getSelectedLabels() {
        String[] stringArray = new String[this.getComponentCount()];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Checkbox checkbox = (Checkbox)this.getComponent(i);
            if (!checkbox.getState()) continue;
            ++n;
            stringArray[i] = checkbox.getLabel();
        }
        String[] stringArray2 = new String[n];
        if (n > 0) {
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray2[n2++] = stringArray[i];
            }
        }
        return stringArray2;
    }

    public void setSelectedLabels(String[] stringArray) {
        Array array = new Array((Object[])stringArray);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Checkbox checkbox = (Checkbox)this.getComponent(i);
            checkbox.setState(array.contains((Object)checkbox.getLabel()));
        }
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.getComponentCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Checkbox)this.getComponent(i)).getLabel();
        }
        return stringArray;
    }

    public void setLabels(String[] stringArray) {
        Checkbox checkbox;
        int n;
        int n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            checkbox = (Checkbox)this.getComponent(n);
            checkbox.removeItemListener(this.itemMulticaster);
            checkbox.removeFocusListener(this.focusMulticaster);
            checkbox.removeKeyListener(this.keyMulticaster);
            checkbox.removeMouseListener(this.mouseMulticaster);
        }
        this.removeAll();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                checkbox = new Checkbox(stringArray[n], false, this.group);
                checkbox.addItemListener(this.itemMulticaster);
                checkbox.addFocusListener(this.focusMulticaster);
                checkbox.addKeyListener(this.keyMulticaster);
                checkbox.addMouseListener(this.mouseMulticaster);
                checkbox.setEnabled(this.isEnabled());
                this.add(checkbox);
            }
        }
        this.repaint(100L);
    }

    public boolean isGrouped() {
        return this.group != null;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public void setGrouped(boolean bl) {
        if (bl != (this.group != null)) {
            this.group = bl ? new CheckboxGroup() : null;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                ((Checkbox)this.getComponent(i)).setCheckboxGroup(this.group);
            }
        }
        if (bl && (this.groupSelectedIndex > 0 || this.groupSelectedLabel != null)) {
            if (this.groupSelectedIndex > 0) {
                this.setSelectedIndex(this.groupSelectedIndex);
            } else {
                this.setSelectedLabel(this.groupSelectedLabel);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (this.orientation != n) {
            this.orientation = n;
            this.gridLayout.setColumns(1);
            this.gridLayout.setRows(this.orientation == 0 ? 1 : 0);
            this.gridLayout.setColumns(this.orientation == 0 ? 0 : 1);
            this.invalidate();
            this.repaint(100L);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).invalidate();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setBackground(color);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(bl);
        }
    }

    public CheckboxPanel() {
        this.itemMulticaster = new ItemMulticaster();
        this.focusMulticaster = new FocusMulticaster();
        this.keyMulticaster = new KeyMulticaster();
        this.mouseMulticaster = new MouseMulticaster();
        super.setLayout(this.gridLayout);
        this.setMargins(new Insets(6, 6, 6, 6));
        this.setBevelInner(1);
        this.setBevelOuter(2);
        this.setOrientation(1);
    }
}

