/*
 * Decompiled with CFR 0.152.
 */
package Dialogos;

import Analizador.ArcoAutomata;
import Analizador.AutomataConjuntoConfiguraciones;
import AnalizadorLALR1.AutomataConjuntoConfiguracionesLALR1;
import AnalizadorLALR1.ConjuntoConfiguracionesLALR1;
import AnalizadorLR1.AutomataConjuntoConfiguracionesLR1;
import AnalizadorLR1.ConjuntoConfiguracionesLR1;
import AnalizadorSLR1.AutomataConjuntoConfiguracionesSLR1;
import AnalizadorSLR1.ConjuntoConfiguracionesSLR1;
import Dialogos.VentanaTexto;
import grafos.Algoritmo;
import grafos.Dimension2D;
import grafos.Grafo;
import grafos.Punto2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import servicios.DatoSistema;
import servicios.GestorLiterales;
import uci.gef.Arco;
import uci.gef.Editor;
import uci.gef.JGraph;
import uci.gef.JGraphFrame;
import uci.gef.Nodo;

public class VentanaAutomata {
    protected JGraphFrame _jgf;
    private GestorLiterales gesLit = (GestorLiterales)DatoSistema.darDato("GESTOR_LITERALES");
    AutomataConjuntoConfiguraciones automata;
    private static final int LALR1 = 0;
    private static final int SLR1 = 1;
    private static final int LR1 = 2;
    private int tipo;

    public VentanaAutomata(AutomataConjuntoConfiguraciones automata) {
        int i;
        grafos.Nodo nodo;
        int i2;
        this.automata = automata;
        if (automata instanceof AutomataConjuntoConfiguracionesSLR1) {
            this.tipo = 1;
        } else if (automata instanceof AutomataConjuntoConfiguracionesLALR1) {
            this.tipo = 0;
        } else if (automata instanceof AutomataConjuntoConfiguracionesLR1) {
            this.tipo = 2;
        }
        if (this.tipo == 1) {
            this._jgf = new JGraphFrame(this.gesLit.darLiteral("tituloAutomataSLR1"));
        } else if (this.tipo == 0) {
            this._jgf = new JGraphFrame(this.gesLit.darLiteral("tituloAutomataLALR1"));
        } else if (this.tipo == 2) {
            this._jgf = new JGraphFrame(this.gesLit.darLiteral("tituloAutomataLR1"));
        }
        new Frame().getToolkit().beep();
        ((Component)this._jgf).setBounds(10, 10, 500, 400);
        new Frame().getToolkit().beep();
        JGraph jg = this._jgf.getGraph();
        Editor ed = jg.getEditor();
        Algoritmo algoritmo = new Algoritmo();
        double posX = 10.0;
        double posY = 10.0;
        int ancho = 80;
        int alto = 40;
        Grafo grafo = new Grafo();
        for (i2 = 0; i2 < automata.numNodos(); ++i2) {
            nodo = new grafos.Nodo(posX, posY, ancho, alto, automata.obtenerNodo(i2).identificador(), automata.obtenerNodo(i2).toString());
            grafo.insertarNodo(nodo);
        }
        for (i2 = 0; i2 < automata.numArcos(); ++i2) {
            ArcoAutomata arcoAut = automata.obtenerArco(i2);
            int destino = arcoAut.nodoDestino();
            int origen = arcoAut.nodoOrigen();
            grafo.insertarEje(destino, origen, arcoAut.simbolo().toString());
        }
        algoritmo.distribuir(grafo);
        int minX = 0;
        int minY = 0;
        for (i = 0; i < grafo.numeroDeNodos(); ++i) {
            nodo = grafo.obtenerNodoDeIndice(i);
            Punto2D pos = nodo.obtenerPosicion();
            if ((int)pos.x < minX) {
                minX = (int)pos.x;
            }
            if ((int)pos.y >= minY) continue;
            minY = (int)pos.y;
        }
        minX = minX * -1 + 10;
        minY = minY * -1 + 10;
        ancho = 0;
        alto = 0;
        for (i = 0; i < grafo.numeroDeNodos(); ++i) {
            nodo = grafo.obtenerNodoDeIndice(i);
            Punto2D pos = nodo.obtenerPosicion();
            Dimension2D dim = nodo.obtenerDimension();
            int px = 3 * (minX + (int)pos.x);
            int py = 3 * (minY + (int)pos.y);
            Nodo nodoGef = new Nodo(px, py, dim.ancho, dim.alto, Color.black, Color.white, this, new Integer(nodo.obtenerIndice()).toString(), nodo.obtenerTexto());
            ed.add(nodoGef);
            if (px > ancho) {
                ancho = px;
            }
            if (py <= alto) continue;
            alto = py;
        }
        ((Component)this._jgf).setBounds(10, 10, ancho + 110, alto + 120);
        for (int i3 = 0; i3 < automata.numArcos(); ++i3) {
            ArcoAutomata arcoAut = automata.obtenerArco(i3);
            int destino = arcoAut.nodoDestino();
            int origen = arcoAut.nodoOrigen();
            Arco arco = new Arco(new Integer(origen).toString(), new Integer(destino).toString(), arcoAut.simbolo().toString());
            ed.add(arco);
        }
    }

    public void show() {
        this._jgf.repaint();
        this._jgf.show();
    }

    public void mostrarConjunto(String id) {
        Component dialogo = null;
        if (this.tipo == 1) {
            ConjuntoConfiguracionesSLR1 conjunto = (ConjuntoConfiguracionesSLR1)this.automata.obtenerNodo(new Integer(id));
            dialogo = new VentanaTexto(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.gesLit.darLiteral("tituloConjuntoConfig")))).append(" ").append(conjunto.identificador()))), conjunto.toString(), new Dimension(249, 221));
        } else if (this.tipo == 2) {
            ConjuntoConfiguracionesLR1 conjunto = (ConjuntoConfiguracionesLR1)this.automata.obtenerNodo(new Integer(id));
            dialogo = new VentanaTexto(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.gesLit.darLiteral("tituloConjuntoConfig")))).append(" ").append(conjunto.identificador()))), conjunto.toString(), new Dimension(249, 221));
        } else if (this.tipo == 0) {
            ConjuntoConfiguracionesLALR1 conjunto = (ConjuntoConfiguracionesLALR1)this.automata.obtenerNodo(new Integer(id));
            dialogo = new VentanaTexto(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.gesLit.darLiteral("tituloConjuntoConfig")))).append(" ").append(conjunto.identificador()))), conjunto.toString(), new Dimension(249, 221));
        }
        dialogo.setLocation(10, 10);
        ((Window)dialogo).show();
    }

    static {
        LALR1 = 0;
        SLR1 = 1;
        LR1 = 2;
    }
}

