/*
 * Decompiled with CFR 0.152.
 */
package Dialogos;

import Dialogos.AreaDeDibujo;
import Dialogos.VentanaArbolDescendente_bCerrar_actionAdapter;
import Dialogos.arcoArbol;
import Dialogos.nodoArbol;
import Dialogos.nodoArco;
import Dialogos.vectorDesplazamiento;
import gramatica.Gramatica;
import gramatica.ListaSimbolos;
import gramatica.Simbolo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import servicios.DatoSistema;
import servicios.GestorLiterales;

public class VentanaArbolDescendente
extends JFrame {
    public static final int DIRECTO = 0;
    public static final int PASOS = 1;
    public static final float SEPARACION_NIVELES = 50.0f;
    Vector nodosPendientes = new Vector();
    vectorDesplazamiento nodosDesplazar = new vectorDesplazamiento();
    float posXprimerDesplazar;
    int maxPosX = 0;
    int maxPosY = 0;
    int numNodos = 0;
    int tipoSimulacion;
    Gramatica g;
    boolean cerrado = false;
    nodoArbol nodoRaiz;
    JScrollPane jScrollPane1 = new JScrollPane();
    AreaDeDibujo miCanvas = new AreaDeDibujo(1);
    Hashtable tablaNodos = new Hashtable();
    Hashtable tablaArcos = new Hashtable();
    JPanel jPanel1 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton bCerrar = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GestorLiterales gesLit = (GestorLiterales)DatoSistema.darDato("GESTOR_LITERALES");

    public VentanaArbolDescendente(Gramatica g, int tipo) {
        try {
            this.tipoSimulacion = tipo;
            this.g = g;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ((Component)this).setSize(300, 300);
        this.setTitle(this.gesLit.darLiteral("tituloArbol"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        ((Component)this).setBackground(Color.white);
        this.jScrollPane1.getViewport().setBackground(Color.white);
        this.miCanvas.setEditable(false);
        this.jPanel1.setLayout(this.flowLayout1);
        this.bCerrar.setBackground(Color.lightGray);
        this.bCerrar.setText(String.valueOf(String.valueOf(new StringBuffer(" ").append(this.gesLit.darLiteral("submenuCerrar")).append(" "))));
        this.bCerrar.addActionListener(new VentanaArbolDescendente_bCerrar_actionAdapter(this));
        this.jPanel1.setBackground(Color.lightGray);
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 388, 214));
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 307, -1));
        this.jPanel1.add((Component)this.bCerrar, null);
        this.jScrollPane1.getViewport().add((Component)this.miCanvas, null);
    }

    public void ponerRaiz(Simbolo simbolo) {
        if (!this.cerrado) {
            nodoArbol raiz;
            this.nodoRaiz = raiz = this.dibujaNoTerminal(10.0f, 15.0f, simbolo.toString(), 1, 1);
            this.nodosPendientes.add(raiz);
            ++this.numNodos;
            String clave = new String("1|1");
            this.tablaNodos.put(clave, raiz);
            if (this.tipoSimulacion == 1) {
                this.miCanvas.actualizaDibujo(this.tablaNodos, this.tablaArcos, this.maxPosX, this.maxPosY);
            }
        }
    }

    public void anyadeNodos(ListaSimbolos nodos) {
        if (!this.cerrado) {
            nodoArbol padre = (nodoArbol)this.nodosPendientes.firstElement();
            this.nodosPendientes.removeElementAt(0);
            this.nodosDesplazar.borraElemento(padre);
            if (this.nodosDesplazar.size() > 0) {
                nodoArco nodoAux = (nodoArco)this.nodosDesplazar.elementAt(0);
                this.posXprimerDesplazar = nodoAux.nodo.dameX();
                nodoAux = (nodoArco)this.nodosDesplazar.lastElement();
                this.maxPosX = (int)nodoAux.nodo.dameX() + (int)nodoAux.nodo.dameAncho();
            }
            float pixelX = padre.dameX();
            float pixelY = padre.dameY() + 50.0f;
            this.maxPosY = (int)pixelY + 40;
            int nivel = padre.dameNivel() + 1;
            int posicion = 1;
            int noTerminalesInsertados = 0;
            int nodosDesplazados = 0;
            for (int i = 0; i < nodos.tamanyoLista(); ++i) {
                nodoArbol nodoHijo;
                Simbolo hijo = (Simbolo)nodos.elementoEnSC(i);
                if (this.g.estaNoTerminal(hijo)) {
                    nodoHijo = this.dibujaNoTerminal(pixelX, pixelY, hijo.toString(), nivel, posicion);
                    this.nodosPendientes.insertElementAt(nodoHijo, noTerminalesInsertados);
                    ++noTerminalesInsertados;
                } else {
                    nodoHijo = this.dibujaTerminal(pixelX, pixelY, hijo.toString(), nivel, posicion);
                }
                arcoArbol arcoUnion = new arcoArbol(padre.dameX() + padre.dameAncho() / (float)2, padre.dameY() + padre.dameAlto(), nodoHijo.dameX() + nodoHijo.dameAncho() / (float)2, nodoHijo.dameY(), padre.dameNivel(), padre.damePosicion(), posicion);
                String clave = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(padre.dameTexto()))).append("|").append(new Integer(nivel).toString()).append("|").append(new Integer(posicion).toString())));
                this.tablaNodos.put(clave, nodoHijo);
                clave = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(padre.dameTexto()))).append("|").append(new Integer(nivel - 1).toString()).append("|").append(new Integer(padre.damePosicion()).toString()).append("|").append(new Integer(posicion).toString())));
                this.tablaArcos.put(clave, arcoUnion);
                if (posicion == 1) {
                    float posDpadre = padre.dameX() + padre.dameAncho();
                    float posDhijo = nodoHijo.dameX() + nodoHijo.dameAncho();
                    if (posDhijo > posDpadre) {
                        this.desplazarNodos(posDhijo - posDpadre, nodoHijo.dameNivel());
                    }
                } else {
                    float posDhijo = nodoHijo.dameX() + nodoHijo.dameAncho();
                    if (posDhijo > this.posXprimerDesplazar) {
                        this.desplazarNodos(posDhijo - this.posXprimerDesplazar + (float)20, nodoHijo.dameNivel());
                    }
                    this.nodosDesplazar.insertElementAt(new nodoArco(nodoHijo, arcoUnion), nodosDesplazados);
                    ++nodosDesplazados;
                }
                if (this.nodosDesplazar.size() > 0) {
                    nodoArco nodoAux = (nodoArco)this.nodosDesplazar.elementAt(0);
                    this.posXprimerDesplazar = nodoAux.nodo.dameX();
                    nodoAux = (nodoArco)this.nodosDesplazar.lastElement();
                    this.maxPosX = (int)nodoAux.nodo.dameX() + (int)nodoAux.nodo.dameAncho();
                }
                pixelX += nodoHijo.dameSeparacion();
                ++posicion;
            }
        }
        if (this.tipoSimulacion == 1) {
            this.miCanvas.actualizaDibujo(this.tablaNodos, this.tablaArcos, this.maxPosX, this.maxPosY);
        }
    }

    private void desplazarNodos(float desplazamiento, int nivel) {
        for (int i = 1; i <= this.nodosDesplazar.size(); ++i) {
            nodoArco nodoarco = (nodoArco)this.nodosDesplazar.elementAt(i - 1);
            nodoArbol nodo = nodoarco.nodo;
            arcoArbol arco = nodoarco.arco;
            if (nodo.dameNivel() >= nivel) continue;
            Ellipse2D.Float elipse = nodo.dameFigura();
            nodo.desplazar(desplazamiento);
            Line2D.Float linea = arco.dameFigura();
            linea.setLine(arco.dameX1(), arco.dameY1(), arco.dameX2() + desplazamiento, arco.dameY2());
        }
    }

    private nodoArbol dibujaTerminal(float posX, float posY, String simbolo, int nivel, int posicion) {
        Ellipse2D.Float terminal = new Ellipse2D.Float(posX, posY, 40.0f, 30.0f);
        return new nodoArbol(terminal, simbolo, nivel, posicion, 0);
    }

    private nodoArbol dibujaNoTerminal(float posX, float posY, String simbolo, int nivel, int posicion) {
        Ellipse2D.Float terminal = new Ellipse2D.Float(posX, posY, 40.0f, 30.0f);
        return new nodoArbol(terminal, simbolo, nivel, posicion, 1);
    }

    public void mostrarDirecto() {
        this.show();
        this.miCanvas.actualizaDibujo(this.tablaNodos, this.tablaArcos, this.maxPosX, this.maxPosY);
    }

    void bCerrar_actionPerformed(ActionEvent e) {
        this.cerrado = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    static {
        DIRECTO = 0;
        PASOS = 1;
        SEPARACION_NIVELES = 50.0f;
    }
}

