/*
 * Decompiled with CFR 0.152.
 */
package AnalizadorLL1;

import Analizador.AnalizadorDescendente;
import Analizador.TablaAnalisisDescendente;
import Dialogos.DialogoProgresoAnalisis;
import gramatica.Gramatica;
import gramatica.ListaProducciones;
import gramatica.ListaSimbolos;
import gramatica.Produccion;
import gramatica.Simbolo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import servicios.ServiciosGenerales;

public class AnalizadorLL1
extends AnalizadorDescendente {
    private boolean esLL1 = false;
    private Simbolo errorTerminal;
    private Simbolo errorNoTerminal;
    private int elementosApilados;
    private boolean produccionEPS = false;

    public AnalizadorLL1(Frame frame) {
        super(frame);
    }

    public void construirTablaLL1(Gramatica G) {
        int j;
        int i;
        boolean estaLambda = false;
        ServiciosGenerales servicios = new ServiciosGenerales();
        this.gramatica = G;
        DialogoProgresoAnalisis progreso = new DialogoProgresoAnalisis(this.frameSuperior, "Anagra", this.gesLit.darLiteral("mensajeAnalizandoLL1"));
        Point p = this.frameSuperior.getLocation();
        ((Component)progreso).setLocation((this.frameSuperior.getSize().width - progreso.getSize().width) / 2 + p.x, (this.frameSuperior.getSize().height - progreso.getSize().height) / 2 + p.y);
        ((Component)progreso).setVisible(true);
        progreso.actualizarBarra(0);
        this.tablaAnalisis = new TablaAnalisisDescendente(G.listaTerminales(), G.listaNoTerminales());
        for (i = 0; i < G.numProducciones(); ++i) {
            int ll = progreso.darEstadoBarra();
            int nuevo = i * 90 / G.numProducciones();
            if (nuevo > ll) {
                progreso.actualizarBarra(nuevo);
            }
            Produccion produccion = G.produccion(i);
            ListaSimbolos listaSimbolos = servicios.calcularPrimeroFormaFrase(produccion.parteDcha(), G.conjPrimeros());
            for (j = 0; j < listaSimbolos.tamanyoLista(); ++j) {
                Simbolo simbolo = (Simbolo)listaSimbolos.elementoEn(j);
                if (!simbolo.esLambda()) {
                    this.tablaAnalisis.insertarEnTabla(simbolo, produccion.parteIzda(), produccion);
                    continue;
                }
                estaLambda = true;
            }
            if (!estaLambda) continue;
            listaSimbolos = servicios.siguienteDe(produccion.parteIzda(), G);
            for (j = 0; j < listaSimbolos.tamanyoLista(); ++j) {
                Simbolo aux = (Simbolo)listaSimbolos.elementoEnSC(j);
                if (!G.estaTerminal(aux) || aux.esLambda()) continue;
                this.tablaAnalisis.insertarEnTabla((Simbolo)listaSimbolos.elementoEn(j), produccion.parteIzda(), produccion);
            }
            if (listaSimbolos.estaElemento(new Simbolo("Lambda"))) {
                this.tablaAnalisis.insertarEnTabla(new Simbolo("Lambda"), produccion.parteIzda(), produccion);
            }
            estaLambda = false;
        }
        progreso.actualizarBarra(90);
        this.esLL1 = true;
        for (i = 0; i < G.numNoTerminales() && this.esLL1; ++i) {
            ListaProducciones lprod;
            for (j = 0; j < G.numTerminales() && this.esLL1; ++j) {
                lprod = this.tablaAnalisis.obtenerDeTabla(G.terminal(j), G.noTerminal(i));
                if (lprod.tamanyoLista() <= 1) continue;
                this.esLL1 = false;
                this.errorTerminal = G.terminal(j).copiar();
                this.errorNoTerminal = G.noTerminal(i).copiar();
            }
            if (!this.esLL1 || (lprod = this.tablaAnalisis.obtenerDeTabla(new Simbolo("Lambda"), G.noTerminal(i))).tamanyoLista() <= 1) continue;
            this.esLL1 = false;
            this.errorTerminal = new Simbolo("Lambda");
            this.errorNoTerminal = G.noTerminal(i).copiar();
        }
        progreso.actualizarBarra(100);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Component)progreso).setVisible(false);
        progreso.dispose();
    }

    public TablaAnalisisDescendente tabla() {
        return this.tablaAnalisis;
    }

    public int ejecutarNPasosAnalizador(int n) {
        Simbolo simbolo = new Simbolo("$");
        this.elementosApilados = 0;
        this.produccionEPS = false;
        if (this.primeraIteracion) {
            this.pilaSimbolos.apilarSimbolo(new Simbolo("$"));
            this.pilaSimbolos.apilarSimbolo(this.gramatica.simboloInicial());
            this.primeraIteracion = false;
        } else {
            Simbolo siguiente = (Simbolo)this.entradaAnalizador.elementoEn(0);
            if (siguiente.esLambda()) {
                siguiente = new Simbolo("Lambda");
            }
            if (!this.gramatica.estaTerminal(siguiente) && !siguiente.esLambda()) {
                return 0;
            }
            for (int j = 1; j <= n; ++j) {
                simbolo = this.pilaSimbolos.cima();
                if (simbolo.esLambda()) {
                    simbolo = new Simbolo("Lambda");
                }
                if (simbolo == null) {
                    if (siguiente == null) {
                        return 1;
                    }
                    return 0;
                }
                if (siguiente == null) {
                    return 0;
                }
                if (simbolo.esLambda()) {
                    if (siguiente.esLambda()) {
                        return 2;
                    }
                    return 0;
                }
                if (this.gramatica.estaTerminal(simbolo)) {
                    if (simbolo.esIgualQue(siguiente)) {
                        this.pilaSimbolos.desapilar();
                        this.entradaAnalizador.borraElementoEn(0);
                        continue;
                    }
                    return 0;
                }
                ListaProducciones lprod = this.tablaAnalisis.obtenerDeTabla(siguiente, simbolo);
                if (lprod.tamanyoLista() != 0) {
                    this.pilaSimbolos.desapilar();
                    Produccion prod = (Produccion)lprod.elementoEn(0);
                    ListaSimbolos lsimb = prod.parteDcha();
                    for (int i = lsimb.tamanyoLista() - 1; i >= 0; --i) {
                        this.pilaSimbolos.apilarSimbolo((Simbolo)lsimb.elementoEn(i));
                        ++this.elementosApilados;
                    }
                    if (lsimb.tamanyoLista() == 0) {
                        this.produccionEPS = true;
                    }
                    this.serieProducciones.anyadeElemento(prod);
                    continue;
                }
                return 0;
            }
        }
        return 1;
    }

    public boolean esLL1() {
        return this.esLL1;
    }

    public ListaSimbolos errorLL1() {
        ListaSimbolos lsimb = new ListaSimbolos();
        if (this.errorNoTerminal != null) {
            lsimb.anyadeElemento(this.errorNoTerminal);
        }
        if (this.errorTerminal != null) {
            if (this.errorTerminal.esLambda()) {
                lsimb.anyadeElemento(new Simbolo("$"));
            } else {
                lsimb.anyadeElemento(this.errorTerminal);
            }
        }
        return lsimb;
    }

    public int darNumSimbolosApiladosUltimoPaso() {
        return this.elementosApilados;
    }

    public boolean esProduccionEPS() {
        return this.produccionEPS;
    }
}

