/*
 * Decompiled with CFR 0.152.
 */
package Analizador;

import gramatica.ListaProduccionesPunto;
import gramatica.ProduccionPunto;

public abstract class ConjuntoConfiguraciones {
    protected int numeroConjunto;
    protected ListaProduccionesPunto producciones;

    public ConjuntoConfiguraciones(int identificador) {
        this.numeroConjunto = identificador;
    }

    public ConjuntoConfiguraciones(int identificador, ListaProduccionesPunto lprod) {
        this.producciones = lprod;
        this.numeroConjunto = identificador;
    }

    public void anyadeProduccion(ProduccionPunto produccion) {
        this.producciones.anyadeElemento(produccion);
    }

    public void borraProduccion(ProduccionPunto produccion) {
        this.producciones.borraElemento(produccion);
    }

    public boolean estaProduccion(ProduccionPunto produccion) {
        return this.producciones.estaElemento(produccion);
    }

    public ProduccionPunto produccionEn(int indice) {
        return (ProduccionPunto)this.producciones.elementoEnSC(indice);
    }

    public int numProducciones() {
        return this.producciones.tamanyoLista();
    }

    public void mostrar() {
        System.out.println(" ");
        System.out.println("Nodo ".concat(String.valueOf(String.valueOf(this.numeroConjunto))));
        this.producciones.mostrar();
    }

    public String toString() {
        String resultado = new String("");
        resultado = resultado.concat(this.producciones.toString());
        return resultado;
    }

    public void ponerIdentificador(int id) {
        this.numeroConjunto = id;
    }

    public boolean esIgualQue(ConjuntoConfiguraciones conjunto) {
        boolean resultado = true;
        if (!this.producciones.esIgualQue(conjunto.producciones())) {
            return false;
        }
        return resultado;
    }

    public int identificador() {
        return this.numeroConjunto;
    }

    public ListaProduccionesPunto producciones() {
        return this.producciones;
    }
}

