/*
 * Decompiled with CFR 0.152.
 */
package uci.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.util.ChildGenerator;
import uci.util.Predicate;
import uci.util.PredicateTrue;

public class Set
implements Serializable {
    public static final int TC_LIMIT = 50;
    private Vector _v;

    public Set() {
        this._v = new Vector();
    }

    public Set(int n) {
        this._v = new Vector(n);
    }

    public Set(Object o1) {
        this._v = new Vector();
        this.addElement(o1);
    }

    public void addElement(Object o) {
        if (!this.contains(o)) {
            this._v.addElement(o);
        }
    }

    public void addAllElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public void addAllElementsSuchThat(Enumeration enumeration, Predicate p) {
        if (p instanceof PredicateTrue) {
            this.addAllElements(enumeration);
        } else {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!p.predicate(e)) continue;
                this.addElement(e);
            }
        }
    }

    public void addAllElements(Set s) {
        this.addAllElements(s.elements());
    }

    public void addAllElementsSuchThat(Set s, Predicate p) {
        this.addAllElementsSuchThat(s.elements(), p);
    }

    public void remove(Object o) {
        this._v.removeElement(o);
    }

    public void removeElement(Object o) {
        this._v.removeElement(o);
    }

    public void removeAllElements() {
        this._v.removeAllElements();
    }

    public boolean contains(Object o) {
        return this._v.contains(o);
    }

    public boolean containsSuchThat(Predicate p) {
        return this.findSuchThat(p) != null;
    }

    public Object findSuchThat(Predicate p) {
        Enumeration elts = this.elements();
        while (elts.hasMoreElements()) {
            Object o = elts.nextElement();
            if (!p.predicate(o)) continue;
            return o;
        }
        return null;
    }

    public Enumeration elements() {
        return this._v.elements();
    }

    public Vector asVector() {
        return this._v;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Set)) {
            return false;
        }
        Set set = (Set)o;
        if (set.size() != this.size()) {
            return false;
        }
        Enumeration myEs = this.elements();
        while (myEs.hasMoreElements()) {
            Object obj = myEs.nextElement();
            if (set.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public Object firstElement() {
        return this._v.firstElement();
    }

    public int size() {
        return this._v.size();
    }

    public String toString() {
        String res = "Set{";
        Enumeration eles = this.elements();
        while (eles.hasMoreElements()) {
            res = String.valueOf(String.valueOf(res)).concat(String.valueOf(String.valueOf(eles.nextElement().toString())));
            if (!eles.hasMoreElements()) continue;
            res = String.valueOf(String.valueOf(res)).concat(", ");
        }
        return String.valueOf(String.valueOf(res)).concat("}");
    }

    public Set transitiveClosure(ChildGenerator cg) {
        return this.transitiveClosure(cg, 50, PredicateTrue.theInstance());
    }

    public Set reachable(ChildGenerator cg) {
        return this.reachable(cg, 50, PredicateTrue.theInstance());
    }

    public Set reachable(ChildGenerator cg, int max, Predicate p) {
        Set kids = new Set();
        Enumeration rootEnum = this.elements();
        while (rootEnum.hasMoreElements()) {
            Object r = rootEnum.nextElement();
            kids.addAllElementsSuchThat(cg.gen(r), p);
        }
        return kids.transitiveClosure(cg, max, p);
    }

    public Set transitiveClosure(ChildGenerator cg, int max, Predicate p) {
        int iterCount = 0;
        int lastSize = -1;
        Set touched = new Set();
        Set recent = this;
        touched.addAllElements(this);
        while (iterCount < max && touched.size() > lastSize) {
            ++iterCount;
            lastSize = touched.size();
            Set frontier = new Set();
            Enumeration recentEnum = recent.elements();
            while (recentEnum.hasMoreElements()) {
                Enumeration frontsEnum = cg.gen(recentEnum.nextElement());
                frontier.addAllElementsSuchThat(frontsEnum, p);
            }
            touched.addAllElements(frontier);
            recent = frontier;
        }
        return touched;
    }

    static {
        TC_LIMIT = 50;
    }
}

