/*
 * Decompiled with CFR 0.152.
 */
package uci.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uci.ui.PropSheet;
import uci.ui.PropSheetCategory;

public class TabPropFrame
extends JFrame
implements ChangeListener,
ActionListener {
    private PropSheet _lastPropSheet = null;
    private int _lastTab = -1;
    private Vector _sheets = new Vector();
    private JTabbedPane tabPanel;
    private Panel choicePanel;
    private PropSheetCategory PropSheetCategory1;
    private PropSheetCategory PropSheetCategory2;
    private PropSheetCategory PropSheetCategory3;
    private PropSheetCategory PropSheetCategory4;
    private PropSheetCategory PropSheetCategory5;
    private JPanel buttonPanel;
    private JCheckBox autoApplyCheckbox;
    private JButton applyButton;
    private JButton revertButton;
    private JButton closeButton;
    protected Object _selection = null;

    public TabPropFrame() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.addNotify();
        this.resize(this.insets().left + this.insets().right + 250, this.insets().top + this.insets().bottom + 406);
        this.getContentPane().setFont(new Font("Dialog", 0, 10));
        this.tabPanel = new JTabbedPane();
        this.tabPanel.addChangeListener(this);
        this.getContentPane().add((Component)this.tabPanel, "Center");
        this.PropSheetCategory1 = new PropSheetCategory(this);
        this.PropSheetCategory1.reshape(12, 33, 276, 307);
        this.PropSheetCategory2 = new PropSheetCategory(this);
        this.PropSheetCategory2.reshape(12, 33, 276, 307);
        this.PropSheetCategory3 = new PropSheetCategory(this);
        this.PropSheetCategory3.reshape(12, 33, 276, 307);
        this.PropSheetCategory4 = new PropSheetCategory(this);
        this.PropSheetCategory4.reshape(12, 33, 276, 307);
        this.PropSheetCategory5 = new PropSheetCategory(this);
        this.PropSheetCategory5.reshape(12, 33, 276, 307);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.buttonPanel.reshape(this.insets().left + 0, this.insets().top + 375, 300, 31);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.autoApplyCheckbox = new JCheckBox("AutoApply");
        this.autoApplyCheckbox.reshape(66, 5, 78, 21);
        this.autoApplyCheckbox.setSelected(true);
        this.autoApplyCheckbox.addChangeListener(this);
        this.buttonPanel.add(this.autoApplyCheckbox);
        this.applyButton = new JButton("Apply");
        this.applyButton.reshape(149, 5, 40, 21);
        this.applyButton.enable(false);
        this.buttonPanel.add(this.applyButton);
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.revertButton = new JButton("Revert");
        this.revertButton.reshape(149, 5, 40, 21);
        this.revertButton.enable(false);
        this.revertButton.addActionListener(this);
        this.revertButton.setEnabled(false);
        this.buttonPanel.add(this.revertButton);
        this.closeButton = new JButton("Close");
        this.closeButton.reshape(194, 5, 40, 21);
        this.closeButton.addActionListener(this);
        this.setTitle("Props");
        this.PropSheetCategory1.setCategory("Geometry");
        this.PropSheetCategory2.setCategory("Text");
        this.PropSheetCategory3.setCategory("Style");
        this.PropSheetCategory4.setCategory("Model");
        this.PropSheetCategory5.setCategory("All");
        this.addPropSheet(this.PropSheetCategory4);
        this.addPropSheet(this.PropSheetCategory1);
        this.addPropSheet(this.PropSheetCategory2);
        this.addPropSheet(this.PropSheetCategory3);
        this.addPropSheet(this.PropSheetCategory5);
        this.tabPanel.setSelectedIndex(0);
    }

    public TabPropFrame(String title) {
        this();
        this.setTitle(title);
    }

    public Component getCurrentSheet() {
        return this.tabPanel.getSelectedComponent();
    }

    public void addPropSheet(PropSheet ps) {
        if (this.tabPanel == null) {
            return;
        }
        int i = this.tabPanel.getTabCount();
        this.tabPanel.addTab(ps.getTabName(), ps);
        this.tabPanel.setEnabledAt(i, ps.canEdit(this._selection));
        String curSheetName = ps.getTabName();
        this._sheets.addElement(ps);
    }

    public synchronized void show() {
        this.move(50, 50);
        super.show();
    }

    public void select(Object item) {
        if (item != this._selection) {
            this._selection = item;
            this.updateTabs();
            this.updateCurSheet();
            this.setTitle("Properties - ".concat(String.valueOf(String.valueOf(item == null ? "(nothing)" : item.toString()))));
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.closeButton) {
            this.closeButton_Clicked(ae);
        }
        if (src == this.applyButton) {
            this.applyButton_Clicked(ae);
        }
        if (src == this.revertButton) {
            this.revertButton_Clicked(ae);
        }
    }

    public void stateChanged(ChangeEvent ce) {
        Object src = ce.getSource();
        if (src == this.autoApplyCheckbox) {
            this.autoApplyCheckbox_Action(ce);
        }
        if (src == this.tabPanel) {
            this.updateCurSheet();
        }
    }

    void tabPanel_Action(Event event) {
        this.updateCurSheet();
    }

    protected void autoApplyCheckbox_Action(ChangeEvent event) {
        this.applyButton.setEnabled(!this.autoApplyCheckbox.isSelected());
        this.revertButton.setEnabled(!this.autoApplyCheckbox.isSelected());
        Component p = this.getCurrentSheet();
        if (p instanceof PropSheet) {
            ((PropSheet)p).setAutoApply(this.autoApplyCheckbox.isSelected());
        }
    }

    void closeButton_Clicked(ActionEvent event) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    void applyButton_Clicked(ActionEvent event) {
        Component sheet = this.getCurrentSheet();
        if (sheet instanceof PropSheet) {
            ((PropSheet)sheet).apply();
        }
    }

    void revertButton_Clicked(ActionEvent event) {
        Component sheet = this.getCurrentSheet();
        if (sheet instanceof PropSheet) {
            ((PropSheet)sheet).revert();
        }
    }

    public void updateTabs() {
        try {
            int firstEnabled = -1;
            int numTabs = this.tabPanel.getTabCount();
            for (int tab = 0; tab < numTabs; ++tab) {
                if (!this.updateTabEnabled(tab) || firstEnabled != -1) continue;
                firstEnabled = tab;
            }
            int curTab = this.tabPanel.getSelectedIndex();
            if (curTab < 0 && firstEnabled != -1) {
                this.tabPanel.setSelectedIndex(firstEnabled);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean updateTabEnabled(int tab) {
        try {
            Component c = this.tabPanel.getComponentAt(tab);
            boolean canEdit = c instanceof PropSheet ? ((PropSheet)c).canEdit(this._selection) : true;
            this.tabPanel.setEnabledAt(tab, canEdit);
            boolean bl = canEdit;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void updateCurSheet() {
        int curTab = this.tabPanel.getSelectedIndex();
        Component c = this.tabPanel.getSelectedComponent();
        if (c instanceof PropSheet) {
            PropSheet curPropSheet = (PropSheet)c;
            curPropSheet.setSelection(this._selection);
            if (this._lastPropSheet != curPropSheet && this._lastPropSheet != null) {
                this._lastPropSheet.setSelection(null);
            }
            this._lastTab = curTab;
            this._lastPropSheet = curPropSheet;
        }
    }

    public static void main(String[] args) {
        TabPropFrame ps = new TabPropFrame();
        ps.show();
    }
}

