/*
 * Decompiled with CFR 0.152.
 */
package uci.graph;

import java.io.Serializable;
import java.util.Vector;
import uci.gef.NetEdge;
import uci.gef.NetList;
import uci.gef.NetNode;
import uci.gef.NetPort;
import uci.graph.MutableGraphSupport;

public class DefaultGraphModel
extends MutableGraphSupport
implements Serializable {
    protected NetList _netList;

    public DefaultGraphModel() {
        this._netList = new NetList();
    }

    public DefaultGraphModel(NetList nl) {
        this._netList = nl;
    }

    public NetList getNetList() {
        return this._netList;
    }

    public void setNetList(NetList nl) {
        this._netList = nl;
    }

    public boolean OK() {
        return this._netList != null;
    }

    public Vector getNodes() {
        return this._netList.getNodes();
    }

    public Vector getEdges() {
        return this._netList.getEdges();
    }

    public Vector getPorts(Object nodeOrEdge) {
        if (nodeOrEdge instanceof NetNode) {
            return ((NetNode)nodeOrEdge).getPorts();
        }
        if (nodeOrEdge instanceof NetEdge) {
            return ((NetEdge)nodeOrEdge).getPorts();
        }
        return null;
    }

    public Object getOwner(Object port) {
        if (port instanceof NetPort) {
            return ((NetPort)port).getParent();
        }
        return null;
    }

    public Vector getInEdges(Object port) {
        if (port instanceof NetPort) {
            return ((NetPort)port).getEdges();
        }
        return null;
    }

    public Vector getOutEdges(Object port) {
        if (port instanceof NetPort) {
            return ((NetPort)port).getEdges();
        }
        return null;
    }

    public Object getSourcePort(Object edge) {
        if (edge instanceof NetEdge) {
            return ((NetEdge)edge).getSourcePort();
        }
        return null;
    }

    public Object getDestPort(Object edge) {
        if (edge instanceof NetEdge) {
            return ((NetEdge)edge).getDestPort();
        }
        return null;
    }

    public boolean canAddNode(Object node) {
        return node instanceof NetNode;
    }

    public boolean canAddEdge(Object edge) {
        return edge instanceof NetEdge;
    }

    public void removeNode(Object node) {
        NetNode n = (NetNode)node;
        this._netList.removeNode(n);
        this.fireNodeRemoved(n);
    }

    public void addNode(Object node) {
        NetNode n = (NetNode)node;
        this._netList.addNode(n);
        this.fireNodeAdded(n);
    }

    public void addEdge(Object edge) {
        NetEdge e = (NetEdge)edge;
        this._netList.addEdge(e);
        this.fireEdgeAdded(e);
    }

    public void removeEdge(Object edge) {
        NetEdge e = (NetEdge)edge;
        this._netList.removeEdge(e);
        this.fireEdgeRemoved(e);
    }

    public boolean canConnect(Object srcPort, Object destPort) {
        if (srcPort instanceof NetPort && destPort instanceof NetPort) {
            NetPort s = (NetPort)srcPort;
            NetPort d = (NetPort)destPort;
            return s.canConnectTo(this, d) && d.canConnectTo(this, s);
        }
        return false;
    }

    public boolean canConnect(Object srcPort, Object destPort, Class edgeClass) {
        return this.canConnect(srcPort, destPort);
    }

    public Object connect(Object srcPort, Object destPort) {
        if (!this.canConnect(srcPort, destPort)) {
            return null;
        }
        if (srcPort instanceof NetPort && destPort instanceof NetPort) {
            NetPort s = (NetPort)srcPort;
            NetPort d = (NetPort)destPort;
            System.out.println("calling makeEdgeFor:".concat(String.valueOf(String.valueOf(s.getClass().getName()))));
            NetEdge e = s.makeEdgeFor(d);
            return this.connectInternal(s, d, e);
        }
        return null;
    }

    public Object connect(Object srcPort, Object destPort, Class edgeClass) {
        if (!this.canConnect(srcPort, destPort)) {
            System.out.println("illegal connection");
            return null;
        }
        if (srcPort instanceof NetPort && destPort instanceof NetPort) {
            NetPort s = (NetPort)srcPort;
            NetPort d = (NetPort)destPort;
            try {
                NetEdge e = (NetEdge)edgeClass.newInstance();
                Object object = this.connectInternal(s, d, e);
                return object;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Object connectInternal(NetPort s, NetPort d, NetEdge e) {
        System.out.println("connectInternal");
        e.connect(this, s, d);
        this.addEdge(e);
        return e;
    }
}

