/*
 * Decompiled with CFR 0.152.
 */
package uci.graph;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.graph.MutableGraphSupport;

public abstract class AdjacencyListGraphModel
extends MutableGraphSupport
implements Serializable {
    public static String UNLABELED = "Unlabeled";
    protected Vector _nodes = new Vector();
    protected Vector _edges = new Vector();

    public boolean OK() {
        if (this._nodes == null) {
            return false;
        }
        if (this._edges == null) {
            return false;
        }
        Enumeration edgeNum = this._edges.elements();
        while (edgeNum.hasMoreElements()) {
            Object[] e = (Object[])edgeNum.nextElement();
            if (this.containsPort(e[0]) && this.containsPort(e[1])) continue;
            return false;
        }
        return true;
    }

    public Vector getNodes() {
        return this._nodes;
    }

    public Vector getEdges() {
        return this._edges;
    }

    public abstract Vector getPorts(Object var1);

    public abstract Object getOwner(Object var1);

    public Object getSourcePort(Object edge) {
        Object[] labeledEgde = (Object[])edge;
        return labeledEgde[0];
    }

    public Object getDestPort(Object edge) {
        Object[] labeledEgde = (Object[])edge;
        return labeledEgde[1];
    }

    public Vector getInEdges(Object port) {
        Vector<Object[]> res = new Vector<Object[]>();
        Enumeration edgeEnum = this._edges.elements();
        while (edgeEnum.hasMoreElements()) {
            Object[] e = (Object[])edgeEnum.nextElement();
            if (port != e[1]) continue;
            res.addElement(e);
        }
        return res;
    }

    public Vector getOutEdges(Object port) {
        Vector<Object[]> res = new Vector<Object[]>();
        Enumeration edgeEnum = this._edges.elements();
        while (edgeEnum.hasMoreElements()) {
            Object[] e = (Object[])edgeEnum.nextElement();
            if (port != e[0]) continue;
            res.addElement(e);
        }
        return res;
    }

    public boolean canAddNode(Object node) {
        return true;
    }

    public boolean canAddEdge(Object edge) {
        return edge instanceof Object[] && ((Object[])edge).length == 3;
    }

    public void addNode(Object node) {
        this._nodes.addElement(node);
    }

    public void addEdge(Object edge) {
        if (this.canAddEdge(edge)) {
            this._edges.addElement(edge);
        }
    }

    public void removeNode(Object node) {
        this._nodes.removeElement(node);
    }

    public void removeEdge(Object edge) {
        this._edges.removeElement(edge);
    }

    public boolean canConnect(Object srcNode, Object destNode) {
        return true;
    }

    public Object connect(Object srcPort, Object destPort) {
        return this.addLabeledEdge(srcPort, destPort, UNLABELED);
    }

    public Object getEdgeLabel(Object edge) {
        Object[] labeledEgde = (Object[])edge;
        return labeledEgde[2];
    }

    public Object addLabeledEdge(Object srcPort, Object destPort, Object label) {
        Object[] e = new Object[]{srcPort, destPort, label};
        this.addEdge(e);
        return e;
    }

    public Vector getEdgesLabeled(Object label) {
        Vector<Object[]> res = new Vector<Object[]>();
        Enumeration edgeEnum = this._edges.elements();
        while (edgeEnum.hasMoreElements()) {
            Object[] e = (Object[])edgeEnum.nextElement();
            if (label != this.getEdgeLabel(e)) continue;
            res.addElement(e);
        }
        return res;
    }
}

