/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Handle;
import uci.gef.Selection;

public class SelectionResize
extends Selection {
    public SelectionResize(Fig f) {
        super(f);
    }

    public int hitHandle(Rectangle r) {
        int cx = this._content.getX();
        int cy = this._content.getY();
        int cw = this._content.getWidth();
        int ch = this._content.getHeight();
        Rectangle testRect = new Rectangle(0, 0, 0, 0);
        testRect.setBounds(cx - 3, cy - 3, 6, ch + 3);
        boolean leftEdge = r.intersects(testRect);
        testRect.setBounds(cx + cw - 3, cy - 3, 6, ch + 3);
        boolean rightEdge = r.intersects(testRect);
        testRect.setBounds(cx - 3, cy - 3, cw + 3, 6);
        boolean topEdge = r.intersects(testRect);
        testRect.setBounds(cx - 3, cy + ch - 3, cw + 3, 6);
        boolean bottomEdge = r.intersects(testRect);
        if (leftEdge && topEdge) {
            return 0;
        }
        if (rightEdge && topEdge) {
            return 2;
        }
        if (leftEdge && bottomEdge) {
            return 5;
        }
        if (rightEdge && bottomEdge) {
            return 7;
        }
        return -1;
    }

    public void paint(Graphics g) {
        int cx = this._content.getX();
        int cy = this._content.getY();
        int cw = this._content.getWidth();
        int ch = this._content.getHeight();
        g.setColor(Globals.getPrefs().handleColorFor(this._content));
        g.fillRect(cx - 3, cy - 3, 6, 6);
        g.fillRect(cx + cw - 3, cy - 3, 6, 6);
        g.fillRect(cx - 3, cy + ch - 3, 6, 6);
        g.fillRect(cx + cw - 3, cy + ch - 3, 6, 6);
    }

    public void dragHandle(int mX, int mY, int anX, int anY, Handle hand) {
        int x = this._content.getX();
        int y = this._content.getY();
        int w = this._content.getWidth();
        int h = this._content.getHeight();
        int newX = x;
        int newY = y;
        int newW = w;
        int newH = h;
        Dimension minSize = this._content.getMinimumSize();
        int minWidth = minSize.width;
        int minHeight = minSize.height;
        switch (hand.index) {
            case -1: {
                this._content.translate(mX + anX, mY + anY);
                return;
            }
            case 0: {
                newW = x + w - mX;
                newW = newW < minWidth ? minWidth : newW;
                newH = y + h - mY;
                newH = newH < minHeight ? minHeight : newH;
                newX = x + w - newW;
                newY = y + h - newH;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                newW = mX - x;
                newW = newW < minWidth ? minWidth : newW;
                newH = y + h - mY;
                newH = newH < minHeight ? minHeight : newH;
                newY = y + h - newH;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                newW = x + w - mX;
                newW = newW < minWidth ? minWidth : newW;
                newH = mY - y;
                newH = newH < minHeight ? minHeight : newH;
                newX = x + w - newW;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                newW = mX - x;
                newW = newW < minWidth ? minWidth : newW;
                newH = mY - y;
                newH = newH < minHeight ? minHeight : newH;
                break;
            }
            default: {
                System.out.println("invalid handle number");
            }
        }
        this._content.setBounds(newX, newY, newW, newH);
    }
}

