/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import uci.gef.CmdInsertPoint;
import uci.gef.CmdRemovePoint;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Handle;
import uci.gef.Selection;

public class SelectionReshape
extends Selection {
    protected int _selectedHandle = -1;

    public SelectionReshape(Fig f) {
        super(f);
    }

    public int hitHandle(Rectangle r) {
        int npoints = this._content.getNumPoints();
        int[] xs = this._content.getXs();
        int[] ys = this._content.getYs();
        for (int i = 0; i < npoints; ++i) {
            if (!r.contains(xs[i], ys[i])) continue;
            this._selectedHandle = i;
            return i;
        }
        this._selectedHandle = -1;
        return -1;
    }

    public void paint(Graphics g) {
        int npoints = this._content.getNumPoints();
        int[] xs = this._content.getXs();
        int[] ys = this._content.getYs();
        g.setColor(Globals.getPrefs().handleColorFor(this._content));
        for (int i = 0; i < npoints; ++i) {
            g.fillRect(xs[i] - 3, ys[i] - 3, 6, 6);
        }
        if (this._selectedHandle != -1) {
            g.drawRect(xs[this._selectedHandle] - 3 - 2, ys[this._selectedHandle] - 3 - 2, 9, 9);
        }
    }

    public void dragHandle(int mX, int mY, int anX, int anY, Handle h) {
        this._content.setPoints(h, mX, mY);
    }

    public void keyTyped(KeyEvent ke) {
        Editor ce = Globals.curEditor();
        char key = ke.getKeyChar();
        int npoints = this._content.getNumPoints();
        if (this._selectedHandle != -1 && (key == '\u007f' || key == '\b')) {
            ce.executeCmd(new CmdRemovePoint(this._selectedHandle), ke);
            ke.consume();
            return;
        }
        if (key == 'i') {
            if (this._selectedHandle == -1) {
                this._selectedHandle = 0;
            }
            ce.executeCmd(new CmdInsertPoint(this._selectedHandle), ke);
            ke.consume();
            return;
        }
        if (key == 'n') {
            this.startTrans();
            this._selectedHandle = this._selectedHandle == -1 ? 0 : (this._selectedHandle + 1) % npoints;
            this.endTrans();
            ke.consume();
            return;
        }
        if (key == 'p') {
            this.startTrans();
            this._selectedHandle = this._selectedHandle == -1 ? npoints - 1 : (this._selectedHandle + npoints - 1) % npoints;
            this.endTrans();
            ke.consume();
            return;
        }
    }
}

