/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Handle;
import uci.gef.Layer;
import uci.gef.Selection;
import uci.gef.SelectionMove;
import uci.gef.SelectionNoop;
import uci.gef.SelectionReshape;
import uci.gef.SelectionResize;
import uci.gef.event.GraphSelectionEvent;
import uci.gef.event.GraphSelectionListener;

public class SelectionManager
implements Serializable,
KeyListener,
MouseListener,
MouseMotionListener {
    protected Vector _selections = new Vector();
    protected Editor _editor;
    protected EventListenerList _listeners = new EventListenerList();
    protected static Hashtable _SelectionRegistry = new Hashtable();
    static Class class$uci$gef$event$GraphSelectionListener;

    public SelectionManager(Editor ed) {
        this._editor = ed;
    }

    protected void addSelection(Selection s) {
        this._selections.addElement(s);
    }

    protected void addFig(Fig f) {
        this._selections.addElement(SelectionManager.makeSelectionFor(f));
    }

    protected void addAllFigs(Vector v) {
        Enumeration eles = v.elements();
        while (eles.hasMoreElements()) {
            this.addFig((Fig)eles.nextElement());
        }
    }

    protected void removeAllElements() {
        this._selections.removeAllElements();
    }

    protected void removeSelection(Selection s) {
        if (s != null) {
            this._selections.removeElement(s);
        }
    }

    protected void removeFig(Fig f) {
        Selection s = this.findSelectionFor(f);
        if (s != null) {
            this._selections.removeElement(s);
        }
    }

    protected void allDamaged() {
        this._editor.damageAll();
    }

    public void select(Fig f) {
        this.allDamaged();
        this.removeAllElements();
        this.addFig(f);
        this._editor.damageAll();
        this.fireSelectionChanged();
    }

    public void deselect(Fig f) {
        if (this.containsFig(f)) {
            this.removeFig(f);
            this._editor.damaged(f);
            this.fireSelectionChanged();
        }
    }

    public void toggle(Fig f) {
        this._editor.damaged(f);
        if (this.containsFig(f)) {
            this.removeFig(f);
        } else {
            this.addFig(f);
        }
        this._editor.damaged(f);
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        Rectangle damagedArea = this.getBounds();
        this.removeAllElements();
        this._editor.damaged(damagedArea);
        this.fireSelectionChanged();
    }

    public void select(Vector items) {
        this.allDamaged();
        this.removeAllElements();
        this.addAllFigs(items);
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public void toggle(Vector items) {
        this.allDamaged();
        Enumeration figs = ((Vector)items.clone()).elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (this.containsFig(f)) {
                this.removeFig(f);
                continue;
            }
            this.addFig(f);
        }
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public Selection findSelectionFor(Fig f) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            if (!sel.contains(f)) continue;
            return sel;
        }
        return null;
    }

    public boolean contains(Selection s) {
        return this._selections.contains(s);
    }

    public boolean containsFig(Fig f) {
        return this.findSelectionFor(f) != null;
    }

    public boolean getLocked() {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            if (!((Selection)sels.nextElement()).getLocked()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this._selections.size();
    }

    public Vector selections() {
        return this._selections;
    }

    public Vector getFigs() {
        Vector<Fig> figs = new Vector<Fig>(this._selections.size());
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            figs.addElement(((Selection)sels.nextElement()).getContent());
        }
        return figs;
    }

    public void startTrans() {
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).startTrans();
        }
    }

    public void endTrans() {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            ((Selection)sels.nextElement()).endTrans();
        }
    }

    public void paint(Graphics g) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            sel.paint(g);
        }
    }

    public void damage() {
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).damage();
        }
    }

    public boolean contains(int x, int y) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            if (!((Selection)sels.nextElement()).contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public boolean hit(Rectangle r) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            if (!((Selection)sels.nextElement()).hit(r)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getBounds() {
        Rectangle r = null;
        Enumeration sels = this._selections.elements();
        if (sels.hasMoreElements()) {
            r = ((Selection)sels.nextElement()).getBounds();
        } else {
            return new Rectangle(0, 0, 0, 0);
        }
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            r.add(sel.getBounds());
        }
        return r;
    }

    public Rectangle getContentBounds() {
        Rectangle r = null;
        Enumeration sels = this._selections.elements();
        if (sels.hasMoreElements()) {
            r = ((Selection)sels.nextElement()).getContentBounds();
        } else {
            return new Rectangle(0, 0, 0, 0);
        }
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            r.add(sel.getContentBounds());
        }
        return r;
    }

    public void align(int dir) {
        Editor ed = Globals.curEditor();
        Rectangle bbox = this.getContentBounds();
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).align(bbox, dir, ed);
        }
    }

    public void align(Rectangle r, int dir, Editor ed) {
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).align(r, dir, ed);
        }
    }

    public void reorder(int func, Layer lay) {
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).reorder(func, lay);
        }
    }

    public void translate(int dx, int dy) {
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).translate(dx, dy);
        }
    }

    public int hitHandle(Rectangle r) {
        if (this.size() != 1) {
            return -1;
        }
        int hp = ((Selection)this._selections.firstElement()).hitHandle(r);
        return hp;
    }

    public void dragHandle(int mx, int my, int an_x, int an_y, Handle h) {
        if (this.size() != 1) {
            return;
        }
        Selection sel = (Selection)this._selections.firstElement();
        sel.dragHandle(mx, my, an_x, an_y, h);
    }

    public void delete() {
        Enumeration ss = ((Vector)this._selections.clone()).elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).delete();
        }
    }

    public void dispose() {
        Enumeration ss = ((Vector)this._selections.clone()).elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).dispose();
        }
    }

    public void keyTyped(KeyEvent ke) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !ke.isConsumed()) {
            ((Selection)sels.nextElement()).keyTyped(ke);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !ke.isConsumed()) {
            ((Selection)sels.nextElement()).keyPressed(ke);
        }
    }

    public void mouseMoved(MouseEvent me) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseMoved(me);
        }
    }

    public void mouseDragged(MouseEvent me) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseDragged(me);
        }
    }

    public void mouseClicked(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            Object sel = sels.nextElement();
            ((Selection)sel).mouseClicked(me);
        }
    }

    public void mousePressed(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mousePressed(me);
        }
    }

    public void mouseReleased(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseReleased(me);
        }
    }

    public void mouseExited(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseExited(me);
        }
    }

    public void mouseEntered(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseEntered(me);
        }
    }

    public void addGraphSelectionListener(GraphSelectionListener listener2) {
        this._listeners.add(class$uci$gef$event$GraphSelectionListener == null ? (class$uci$gef$event$GraphSelectionListener = SelectionManager.class$("uci.gef.event.GraphSelectionListener")) : class$uci$gef$event$GraphSelectionListener, listener2);
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener2) {
        this._listeners.remove(class$uci$gef$event$GraphSelectionListener == null ? (class$uci$gef$event$GraphSelectionListener = SelectionManager.class$("uci.gef.event.GraphSelectionListener")) : class$uci$gef$event$GraphSelectionListener, listener2);
    }

    protected void fireSelectionChanged() {
        Object[] listeners = this._listeners.getListenerList();
        GraphSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$uci$gef$event$GraphSelectionListener == null ? SelectionManager.class$("uci.gef.event.GraphSelectionListener") : class$uci$gef$event$GraphSelectionListener)) continue;
            if (e == null) {
                e = new GraphSelectionEvent(this._editor, this.getFigs());
            }
            ((GraphSelectionListener)listeners[i + 1]).selectionChanged(e);
        }
        this.updatePropertySheet();
    }

    public void updatePropertySheet() {
        if (this._selections.size() != 1) {
            Globals.propertySheetSubject(null);
        } else {
            Fig f = (Fig)this.getFigs().elementAt(0);
            Globals.propertySheetSubject(f);
        }
    }

    public static Selection makeSelectionFor(Fig f) {
        if (f.isReshapable()) {
            return new SelectionReshape(f);
        }
        if (f.isResizable()) {
            return new SelectionResize(f);
        }
        if (f.isMovable()) {
            return new SelectionMove(f);
        }
        return new SelectionNoop(f);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

