/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.NetEdge;
import uci.gef.NetNode;
import uci.gef.NetPrimitive;
import uci.graph.GraphModel;
import uci.graph.GraphPortHooks;

public class NetPort
extends NetPrimitive
implements GraphPortHooks,
Serializable {
    public static String DEFAULT_EDGE_CLASS = "uci.gef.demo.SampleEdge";
    protected Vector _edges;
    protected Object _parent;

    public NetPort(Object parent) {
        this._parent = parent;
        this._edges = new Vector();
    }

    public NetNode getParentNode() {
        return (NetNode)this._parent;
    }

    public NetEdge getParentEdge() {
        return (NetEdge)this._parent;
    }

    public Object getParent() {
        return this._parent;
    }

    public Vector getEdges() {
        return this._edges;
    }

    public void addEdge(NetEdge edge) {
        this._edges.addElement(edge);
    }

    public void removeEdge(NetEdge edge) {
        this._edges.removeElement(edge);
    }

    public void dispose() {
        Enumeration edges = this._edges.elements();
        while (edges.hasMoreElements()) {
            NetEdge e = (NetEdge)edges.nextElement();
            e.dispose();
        }
        this.firePropertyChange("Disposed", false, true);
    }

    public void postConnect(GraphModel gm, Object otherPort) {
        NetPort otherNetPort = (NetPort)otherPort;
        NetNode parent = this.getParentNode();
        parent.postConnect(gm, otherNetPort.getParentNode(), this, otherNetPort);
    }

    public void postDisconnect(GraphModel gm, Object otherPort) {
        NetPort otherNetPort = (NetPort)otherPort;
        NetNode parent = this.getParentNode();
        parent.postDisconnect(gm, otherNetPort.getParentNode(), this, otherNetPort);
    }

    protected Class defaultEdgeClass(NetPort otherPort) {
        try {
            Class<?> clazz = Class.forName(DEFAULT_EDGE_CLASS);
            return clazz;
        }
        catch (ClassNotFoundException ignore) {
            Class clazz = null;
            return clazz;
        }
    }

    public NetEdge makeEdgeFor(NetPort otherPort) {
        NetEdge edge;
        Class edgeClass = this.defaultEdgeClass(otherPort);
        if (edgeClass == null) {
            System.out.println("defaultEdgeClass is null");
            return null;
        }
        try {
            edge = (NetEdge)edgeClass.newInstance();
        }
        catch (IllegalAccessException ignore) {
            System.out.println("asdasd");
            NetEdge netEdge = null;
            return netEdge;
        }
        catch (InstantiationException ignore) {
            System.out.println("ASdasd");
            NetEdge netEdge = null;
            return netEdge;
        }
        return edge;
    }

    public boolean canConnectTo(GraphModel gm, Object anotherPort) {
        NetNode myNode = this.getParentNode();
        NetNode otherNode = ((NetPort)anotherPort).getParentNode();
        return myNode.canConnectTo(gm, otherNode, anotherPort, this);
    }
}

