/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uci.gef.Editor;
import uci.gef.FigNode;
import uci.gef.Layer;
import uci.gef.NetPort;
import uci.gef.NetPrimitive;
import uci.graph.GraphModel;
import uci.graph.GraphNodeHooks;

public abstract class NetNode
extends NetPrimitive
implements GraphNodeHooks,
Serializable {
    protected Vector _ports;

    public NetNode(NetNode deft, Vector ports) {
        this._ports = ports;
    }

    public NetNode() {
        this(null, new Vector());
    }

    public abstract void initialize(Hashtable var1);

    public Object getAttributes() {
        return null;
    }

    public NetPort getPort(int i) {
        return (NetPort)this._ports.elementAt(i);
    }

    public Vector getPorts() {
        return this._ports;
    }

    public void setPorts(Vector ports) {
        this._ports = ports;
    }

    public void addPort(NetPort p) {
        this._ports.addElement(p);
    }

    public void dispose() {
        Enumeration ps = this._ports.elements();
        while (ps.hasMoreElements()) {
            ((NetPort)ps.nextElement()).dispose();
        }
        this.firePropertyChange("Disposed", false, true);
    }

    public FigNode presentationFor(Layer lay) {
        FigNode fn;
        if (lay != null && (fn = (FigNode)lay.presentationFor(this)) != null) {
            return fn;
        }
        fn = this.makePresentation(lay);
        return fn;
    }

    public abstract FigNode makePresentation(Layer var1);

    public void postConnect(GraphModel gm, Object anotherNode, Object myPort, Object otherPort) {
    }

    public void postDisconnect(GraphModel gm, Object anotherNode, Object myPort, Object otherPort) {
    }

    public boolean canConnectTo(GraphModel gm, Object otherNode, Object otherPort, Object myPort) {
        return true;
    }

    public void postPlacement(Editor ed) {
    }
}

