/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Mode;
import uci.gef.ModeModify;
import uci.gef.SelectionManager;

public class ModeSelect
extends Mode {
    private Point _selectAnchor = new Point(0, 0);
    private Rectangle _selectRect = new Rectangle(0, 0, 0, 0);
    private boolean _showSelectRect = false;
    private boolean _toggleSelection = false;

    public ModeSelect(Editor par) {
        super(par);
    }

    public ModeSelect() {
    }

    public boolean canExit() {
        return false;
    }

    public void mousePressed(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        this._selectAnchor = new Point(x, y);
        this._selectRect.setBounds(x, y, 0, 0);
        this._toggleSelection = me.isShiftDown();
        SelectionManager sm = this._editor.getSelectionManager();
        Rectangle hitRect = new Rectangle(x - 4, y - 4, 8, 8);
        Fig underMouse = this._editor.hit(this._selectAnchor);
        if (underMouse == null && !sm.hit(hitRect)) {
            return;
        }
        if (underMouse != null) {
            if (this._toggleSelection) {
                sm.toggle(underMouse);
            } else if (!sm.containsFig(underMouse)) {
                sm.select(underMouse);
            }
        }
        if (sm.hit(hitRect)) {
            this.gotoModifyMode(me);
        }
        me.consume();
    }

    public void mouseDragged(MouseEvent me) {
        if (me.getModifiers() == 4) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        this._showSelectRect = true;
        int bound_x = Math.min(this._selectAnchor.x, x);
        int bound_y = Math.min(this._selectAnchor.y, y);
        int bound_w = Math.max(this._selectAnchor.x, x) - bound_x;
        int bound_h = Math.max(this._selectAnchor.y, y) - bound_y;
        this._editor.damaged(this._selectRect);
        this._selectRect.setBounds(bound_x, bound_y, bound_w, bound_h);
        this._editor.damaged(this._selectRect);
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        this._showSelectRect = false;
        Vector<Fig> selectList = new Vector<Fig>();
        Enumeration figs = this._editor.figs();
        Rectangle hitRect = new Rectangle(x - 4, y - 4, 8, 8);
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if ((this._toggleSelection || !this._selectRect.isEmpty() || !f.hit(hitRect)) && (this._selectRect.isEmpty() || !f.intersects(this._selectRect))) continue;
            selectList.addElement(f);
        }
        if (this._toggleSelection) {
            this._editor.getSelectionManager().toggle(selectList);
        } else {
            this._editor.getSelectionManager().select(selectList);
        }
        this._selectRect.grow(1, 1);
        this._editor.damaged(this._selectRect);
        if (me.getModifiers() == 4) {
            return;
        }
        me.consume();
    }

    public String instructions() {
        return "  ";
    }

    public void paint(Graphics g) {
        if (this._showSelectRect) {
            Color selectRectColor = Globals.getPrefs().getRubberbandColor();
            g.setColor(selectRectColor);
            g.drawRect(this._selectRect.x, this._selectRect.y, this._selectRect.width, this._selectRect.height);
        }
    }

    protected void gotoModifyMode(MouseEvent me) {
        ModeModify nextMode = new ModeModify(this._editor);
        this._editor.mode(nextMode);
        ((Mode)nextMode).mousePressed(me);
    }
}

