/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import uci.gef.FigNode;
import uci.gef.Globals;
import uci.gef.Layer;
import uci.gef.Mode;
import uci.graph.GraphModel;
import uci.graph.GraphNodeHooks;
import uci.graph.GraphNodeRenderer;
import uci.graph.MutableGraphModel;

public class ModePlace
extends Mode {
    protected Object _node;
    protected FigNode _pers;

    ModePlace(Object node) {
        this._node = node;
        this._pers = null;
    }

    public String instructions() {
        if (this._node == null) {
            return "";
        }
        return "Click to place ".concat(String.valueOf(String.valueOf(this._node.toString())));
    }

    public void mouseEntered(MouseEvent me) {
        this.start();
        this._editor = Globals.curEditor();
        GraphModel gm = this._editor.getGraphModel();
        GraphNodeRenderer renderer = this._editor.getGraphNodeRenderer();
        Layer lay = this._editor.getLayerManager().getActiveLayer();
        this._pers = renderer.getFigNodeFor(gm, lay, this._node);
        me.consume();
    }

    public void mouseExited(MouseEvent me) {
        this._editor.damaged(this._pers);
        this._pers = null;
        me.consume();
    }

    public void mouseMoved(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (this._pers == null) {
            System.out.println("null pers");
            me.consume();
            return;
        }
        this._editor.damaged(this._pers);
        Point snapPt = new Point(x, y);
        this._editor.snap(snapPt);
        this._pers.setLocation(snapPt.x, snapPt.y);
        this._editor.damaged(this._pers);
        me.consume();
    }

    public void mousePressed(MouseEvent me) {
        me.consume();
    }

    public void mouseDragged(MouseEvent me) {
        this.mouseMoved(me);
    }

    public void mouseReleased(MouseEvent me) {
        GraphModel gm = this._editor.getGraphModel();
        if (!(gm instanceof MutableGraphModel)) {
            return;
        }
        this._editor.add(this._pers);
        MutableGraphModel mgm = (MutableGraphModel)gm;
        mgm.addNode(this._node);
        if (this._node instanceof GraphNodeHooks) {
            ((GraphNodeHooks)this._node).postPlacement(this._editor);
        }
        this.done();
        this._editor.getSelectionManager().select(this._pers);
        me.consume();
    }

    public void paint(Graphics g) {
        if (this._pers != null) {
            this._pers.paint(g);
        }
    }
}

