/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.FigNode;
import uci.gef.Mode;
import uci.gef.ModeCreateEdge;

public class ModeManager
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    private Vector _modes = new Vector();
    public Editor _editor;

    public void setEditor(Editor w) {
        this._editor = w;
    }

    public Editor getEditor() {
        return this._editor;
    }

    public ModeManager(Editor ed) {
        this._editor = ed;
    }

    public Vector getModes() {
        return this._modes;
    }

    public void setModes(Vector newModes) {
        this._modes = newModes;
    }

    public Mode top() {
        if (this._modes.isEmpty()) {
            return null;
        }
        return (Mode)this._modes.lastElement();
    }

    public void push(Mode newMode) {
        Class<?> newModeClass = newMode.getClass();
        Enumeration subs = this._modes.elements();
        while (subs.hasMoreElements()) {
            Mode m = (Mode)subs.nextElement();
            if (m.getClass() != newModeClass) continue;
            return;
        }
        this._modes.addElement(newMode);
    }

    public Mode pop() {
        if (this._modes.isEmpty()) {
            return null;
        }
        Mode res = this.top();
        if (res.canExit()) {
            this._modes.removeElement(res);
        }
        return res;
    }

    public void popAll() {
        while (!this._modes.isEmpty() && this.top().canExit()) {
            this._modes.removeElement(this.top());
        }
    }

    public void keyTyped(KeyEvent ke) {
        this.checkModeTransitions(ke);
        for (int i = this._modes.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.keyTyped(ke);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        for (int i = this._modes.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.keyPressed(ke);
        }
    }

    public void mouseMoved(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.mouseMoved(me);
        }
    }

    public void mouseDragged(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.mouseDragged(me);
        }
    }

    public void mouseClicked(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.mouseClicked(me);
        }
    }

    public void mousePressed(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.mousePressed(me);
        }
    }

    public void mouseReleased(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.mouseReleased(me);
        }
    }

    public void mouseEntered(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.mouseEntered(me);
        }
    }

    public void mouseExited(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            Mode m = (Mode)this._modes.elementAt(i);
            m.mouseExited(me);
        }
    }

    public void checkModeTransitions(InputEvent ie) {
        Object startPort;
        int y;
        MouseEvent me;
        int x;
        Fig underMouse;
        if (!this.top().canExit() && ie.getID() == 501 && (underMouse = this._editor.hit(x = (me = (MouseEvent)ie).getX(), y = me.getY())) instanceof FigNode && (startPort = ((FigNode)underMouse).hitPort(x, y)) != null) {
            ModeCreateEdge createArc = new ModeCreateEdge(this._editor);
            this.push(createArc);
            ((Mode)createArc).mousePressed(me);
        }
    }

    public void paint(Graphics g) {
        Enumeration modes = this._modes.elements();
        while (modes.hasMoreElements()) {
            Mode m = (Mode)modes.nextElement();
            m.paint(g);
        }
    }
}

