/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Point;
import java.awt.event.MouseEvent;
import uci.gef.Fig;
import uci.gef.FigPoly;
import uci.gef.Handle;
import uci.gef.ModeCreate;

public class ModeCreateFigPoly
extends ModeCreate {
    protected int _npoints = 0;
    protected int _lastX;
    protected int _lastY;
    protected int _startX;
    protected int _startY;
    protected Handle _handle = new Handle(-1);

    public String instructions() {
        return "Click to add a point; Double-click to finish";
    }

    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        FigPoly p = new FigPoly(snapX, snapY);
        p.addPoint(snapX, snapY);
        this._startX = this._lastX = snapX;
        this._startY = this._lastY = snapY;
        this._npoints = 2;
        return p;
    }

    public void mousePressed(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (this._npoints == 0) {
            super.mousePressed(me);
        }
        if (!this.nearLast(x, y)) {
            this._editor.damaged(this._newItem);
            Point snapPt = new Point(x, y);
            this._editor.snap(snapPt);
            ((FigPoly)this._newItem).addPoint(snapPt.x, snapPt.y);
            ++this._npoints;
            this._editor.damaged(this._newItem);
        }
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (this._npoints > 2 && this.nearLast(x, y)) {
            FigPoly p = (FigPoly)this._newItem;
            this._editor.damaged(this._newItem);
            this._handle.index = p.getNumPoints() - 1;
            p.moveVertex(this._handle, this._startX, this._startY, true);
            this._npoints = 0;
            this._editor.damaged(p);
            this._editor.add(p);
            this._editor.getSelectionManager().select(p);
            this._newItem = null;
            this.done();
            me.consume();
            return;
        }
        this._lastX = x;
        this._lastY = y;
        me.consume();
    }

    public void mouseMoved(MouseEvent me) {
        this.mouseDragged(me);
    }

    public void mouseDragged(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (this._npoints == 0) {
            me.consume();
            return;
        }
        FigPoly p = (FigPoly)this._newItem;
        this._editor.damaged(this._newItem);
        Point snapPt = new Point(x, y);
        this._editor.snap(snapPt);
        this._handle.index = p.getNumPoints() - 1;
        p.moveVertex(this._handle, snapPt.x, snapPt.y, true);
        this._editor.damaged(this._newItem);
        me.consume();
    }

    protected boolean nearLast(int x, int y) {
        return x > this._lastX - 8 && x < this._lastX + 8 && y > this._lastY - 8 && y < this._lastY + 8;
    }
}

