/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.event.MouseEvent;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.FigLine;
import uci.gef.FigNode;
import uci.gef.Globals;
import uci.gef.LayerManager;
import uci.gef.ModeCreate;
import uci.graph.GraphModel;
import uci.graph.MutableGraphModel;

public class ModeCreateEdge
extends ModeCreate {
    private Object _startPort;
    private Fig _startPortFig;
    private FigNode _sourceFigNode;
    private Object _newEdge;

    public ModeCreateEdge() {
    }

    public ModeCreateEdge(Editor par) {
        super(par);
    }

    public String instructions() {
        return "Drag to define an edge to another port";
    }

    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        return new FigLine(snapX, snapY, 0, 0, Globals.getPrefs().getRubberbandColor());
    }

    public void mousePressed(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        Editor _editor = Globals.curEditor();
        Fig underMouse = _editor.hit(x, y);
        if (underMouse == null) {
            this.done();
            me.consume();
            return;
        }
        if (!(underMouse instanceof FigNode)) {
            this.done();
            me.consume();
            return;
        }
        this._sourceFigNode = (FigNode)underMouse;
        this._startPort = this._sourceFigNode.deepHitPort(x, y);
        if (this._startPort == null) {
            this.done();
            me.consume();
            return;
        }
        this._startPortFig = this._sourceFigNode.getPortFig(this._startPort);
        super.mousePressed(me);
    }

    public void mouseReleased(MouseEvent me) {
        FigNode destFigNode;
        Object foundPort;
        int x = me.getX();
        int y = me.getY();
        Editor _editor = Globals.curEditor();
        Fig f = _editor.hit(x, y);
        GraphModel gm = _editor.getGraphModel();
        if (!(gm instanceof MutableGraphModel)) {
            f = null;
        }
        MutableGraphModel mgm = (MutableGraphModel)gm;
        if (f instanceof FigNode && (foundPort = (destFigNode = (FigNode)f).deepHitPort(x, y)) != null && foundPort != this._startPort) {
            Fig destPortFig = destFigNode.getPortFig(foundPort);
            Class edgeClass = (Class)this.getArg("edgeClass");
            this._newEdge = edgeClass != null ? mgm.connect(this._startPort, foundPort, edgeClass) : mgm.connect(this._startPort, foundPort);
            if (this._newEdge != null) {
                LayerManager lm = _editor.getLayerManager();
                _editor.damaged(this._newItem);
                this._sourceFigNode.damage();
                destFigNode.damage();
                this._newItem = null;
                Fig pers = _editor.getLayerManager().getActiveLayer().presentationFor(this._newEdge);
                if (pers != null) {
                    _editor.getSelectionManager().select(pers);
                }
                this.done();
                me.consume();
                return;
            }
            System.out.println("connection return null");
        }
        this._sourceFigNode.damage();
        _editor.damaged(this._newItem);
        this._newItem = null;
        this.done();
        me.consume();
    }
}

