/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Mode;

public abstract class ModeCreate
extends Mode {
    protected static int _defaultWidth = 32;
    protected static int _defaultHeight = 32;
    protected int anchorX;
    protected int anchorY;
    protected Fig _newItem;
    private Point snapPt = new Point(0, 0);

    public ModeCreate(Editor par) {
        super(par);
    }

    public ModeCreate() {
    }

    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public void mousePressed(MouseEvent me) {
        if (me.getModifiers() == 4) {
            return;
        }
        this.start();
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(me.getX(), me.getY());
            this._editor.snap(this.snapPt);
            this.anchorX = this.snapPt.x;
            this.anchorY = this.snapPt.y;
        }
        this._newItem = this.createNewItem(me, this.anchorX, this.anchorY);
        me.consume();
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void mouseDragged(MouseEvent me) {
        this._editor.damaged(this._newItem);
        this.creationDrag(me.getX(), me.getY());
        this._editor.damaged(this._newItem);
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        if (this._newItem != null) {
            this._editor.damaged(this._newItem);
            this.creationDrag(me.getX(), me.getY());
            this._editor.add(this._newItem);
            this._editor.getSelectionManager().select(this._newItem);
            this._newItem = null;
        }
        this.done();
        me.consume();
    }

    protected void creationDrag(int x, int y) {
        int snapY;
        int snapX;
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(x, y);
            this._editor.snap(this.snapPt);
            snapX = this.snapPt.x;
            snapY = this.snapPt.y;
        }
        if (this.anchorX == snapX && this.anchorY == snapY) {
            this._newItem.createDrag(this.anchorX, this.anchorY, x + _defaultWidth, y + _defaultHeight, snapX + _defaultWidth, snapY + _defaultHeight);
        } else {
            this._newItem.createDrag(this.anchorX, this.anchorY, x, y, snapX, snapY);
            _defaultWidth = snapX - this.anchorX;
            _defaultHeight = snapY - this.anchorY;
        }
    }

    public void paint(Graphics g) {
        if (this._newItem != null) {
            this._newItem.paint(g);
        }
    }

    public abstract Fig createNewItem(MouseEvent var1, int var2, int var3);
}

