/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uci.gef.Fig;
import uci.gef.FigEdge;
import uci.gef.FigNode;
import uci.gef.LayerDiagram;
import uci.gef.NetEdge;
import uci.graph.DefaultGraphEdgeRenderer;
import uci.graph.DefaultGraphNodeRenderer;
import uci.graph.GraphEdgeRenderer;
import uci.graph.GraphEvent;
import uci.graph.GraphListener;
import uci.graph.GraphModel;
import uci.graph.GraphNodeRenderer;

public class LayerPerspective
extends LayerDiagram
implements GraphListener {
    public static final int GAP = 16;
    protected GraphModel _gm;
    protected GraphNodeRenderer _nodeRenderer = new DefaultGraphNodeRenderer();
    protected GraphEdgeRenderer _edgeRenderer = new DefaultGraphEdgeRenderer();
    protected Vector _allowedNetClasses = new Vector();
    protected Hashtable _nodeTypeRegions = new Hashtable();
    protected boolean _stagger = true;

    public LayerPerspective(String name, GraphModel gm) {
        super(name);
        this._gm = gm;
        this._gm.addGraphEventListener(this);
    }

    public GraphModel getGraphModel() {
        return this._gm;
    }

    public void setGraphModel(GraphModel gm) {
        this._gm.removeGraphEventListener(this);
        this._gm = gm;
        this._gm.addGraphEventListener(this);
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._nodeRenderer;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer rend) {
        this._nodeRenderer = rend;
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._edgeRenderer;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer rend) {
        this._edgeRenderer = rend;
    }

    public void allowNetClass(Class c) {
        this._allowedNetClasses.addElement(c);
    }

    public void addNodeTypeRegion(Class nodeClass, Rectangle region) {
        this._nodeTypeRegions.put(nodeClass, region);
    }

    public void putInPosition(Fig f) {
        Class<?> nodeClass = f.getOwner().getClass();
        Rectangle placementRegion = (Rectangle)this._nodeTypeRegions.get(nodeClass);
        if (placementRegion != null) {
            f.setLocation(placementRegion.x, placementRegion.y);
            this.bumpOffOtherNodesIn(f, placementRegion);
        }
    }

    public void bumpOffOtherNodesIn(Fig newFig, Rectangle bounds) {
        Rectangle bbox = newFig.getBounds();
        int col = 0;
        while (bounds.intersects(bbox)) {
            Enumeration overlappers = this.elementsIn(bbox);
            if (!overlappers.hasMoreElements()) {
                return;
            }
            newFig.translate(0, bbox.height + 16);
            bbox.y += bbox.height + 16;
            if (bounds.intersects(bbox)) continue;
            ++col;
            int x = bbox.x + bbox.width + 16;
            int y = bounds.y;
            if (this._stagger) {
                y += col % 2 * (bbox.height + 16) / 2;
            }
            newFig.setLocation(x, y);
            bbox.setLocation(x, y);
        }
    }

    public void nodeAdded(GraphEvent ge) {
        Object node = ge.getArg();
        Fig oldDE = this.presentationFor(node);
        if (oldDE == null) {
            if (!this.shouldShow(node)) {
                System.out.println("node rejected");
                return;
            }
            FigNode newFigNode = this._nodeRenderer.getFigNodeFor(this._gm, this, node);
            if (newFigNode != null) {
                this.putInPosition(newFigNode);
                this.add(newFigNode);
            } else {
                System.out.println("added node de is null");
            }
        }
    }

    public void edgeAdded(GraphEvent ge) {
        System.out.println("LayerPerspective got edgeAdded");
        Object edge = ge.getArg();
        Fig oldDE = this.presentationFor(edge);
        if (oldDE == null) {
            if (!this.shouldShow(edge)) {
                System.out.println("edge rejected");
                return;
            }
            FigEdge newFigEdge = this._edgeRenderer.getFigEdgeFor(this._gm, this, edge);
            if (newFigEdge != null) {
                this.insertAt(newFigEdge, 0);
                newFigEdge.computeRoute();
                newFigEdge.endTrans();
            } else {
                System.out.println("added arc fig is null!!!!!!!!!!!!!!!!");
            }
        }
    }

    public void nodeRemoved(GraphEvent ge) {
    }

    public void edgeRemoved(GraphEvent ge) {
    }

    public void graphChanged(GraphEvent ge) {
    }

    public boolean shouldShow(Object obj) {
        if (this._allowedNetClasses.size() > 0 && !this._allowedNetClasses.contains(obj.getClass())) {
            return false;
        }
        return !(obj instanceof NetEdge) || this.getPortFig(((NetEdge)obj).getSourcePort()) != null && this.getPortFig(((NetEdge)obj).getDestPort()) != null;
    }

    static {
        GAP = 16;
    }
}

