/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Layer;

public class LayerManager
implements Serializable {
    protected Vector _layers = new Vector();
    protected Layer _activeLayer;
    public Editor _editor = null;

    public LayerManager(Editor editor) {
        this._editor = editor;
    }

    public void addLayer(Layer lay) {
        if (this.findLayerNamed(lay.getName()) == null) {
            this._layers.addElement(lay);
            lay.addEditor(this._editor);
            this.setActiveLayer(lay);
        }
    }

    public void removeAllLayers() {
        this._layers.removeAllElements();
        this._activeLayer = null;
    }

    public void replaceActiveLayer(Layer lay) {
        this._activeLayer.removeEditor(this._editor);
        int oldActiveIndex = this._layers.indexOf(this._activeLayer);
        this._layers.setElementAt(lay, oldActiveIndex);
        lay.addEditor(this._editor);
        this.setActiveLayer(lay);
    }

    public void removeLayer(Layer lay) {
        this._layers.removeElement(lay);
        lay.removeEditor(this._editor);
        if (this._activeLayer == lay) {
            this._activeLayer = this._layers.size() >= 1 ? (Layer)this._layers.elementAt(0) : null;
        }
    }

    public Layer findLayerNamed(String aName) {
        Enumeration layers = this._layers.elements();
        while (layers.hasMoreElements()) {
            Layer curLayer = (Layer)layers.nextElement();
            Layer res = curLayer.findLayerNamed(aName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void setActiveLayer(Layer lay) {
        if (this._layers.contains(lay)) {
            this._activeLayer = lay;
        } else {
            System.out.println("That layer is not one of my layers");
        }
    }

    public Layer getActiveLayer() {
        return this._activeLayer;
    }

    public Vector getContents() {
        return this._activeLayer == null ? null : this._activeLayer.getContents();
    }

    public void paint(Graphics g) {
        Enumeration layers = this._layers.elements();
        while (layers.hasMoreElements()) {
            ((Layer)layers.nextElement()).paint(g);
        }
    }

    public void add(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.add(f);
        }
    }

    public void remove(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.remove(f);
        }
    }

    public void removeAll() {
        if (this._activeLayer != null) {
            this._activeLayer.removeAll();
        }
    }

    public Enumeration elements() {
        return this._activeLayer == null ? null : this._activeLayer.elements();
    }

    public Fig hit(Rectangle r) {
        return this._activeLayer == null ? null : this._activeLayer.hit(r);
    }

    public Fig presentationFor(Object obj) {
        Fig f = null;
        Enumeration lays = this._layers.elements();
        while (lays.hasMoreElements()) {
            Layer sub = (Layer)lays.nextElement();
            f = sub.presentationFor(obj);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public void sendToBack(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.sendToBack(f);
        }
    }

    public void bringForward(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.bringForward(f);
        }
    }

    public void sendBackward(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.sendBackward(f);
        }
    }

    public void bringToFront(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.bringToFront(f);
        }
    }

    public void reorder(Fig f, int function) {
        if (this._activeLayer != null) {
            this._activeLayer.reorder(f, function);
        }
    }

    public void setEditor(Editor ed) {
        this._editor = ed;
        Enumeration lays = this._layers.elements();
        while (lays.hasMoreElements()) {
            ((Layer)lays.nextElement()).addEditor(ed);
        }
    }

    public Editor getEditor() {
        return this._editor;
    }
}

