/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import uci.gef.CmdNudge;
import uci.gef.CmdReorder;
import uci.gef.CmdSelectNext;
import uci.gef.Diagram;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Layer;
import uci.gef.LayerDiagram;
import uci.gef.event.GraphSelectionListener;
import uci.graph.DefaultGraphModel;
import uci.graph.GraphEdgeRenderer;
import uci.graph.GraphModel;
import uci.graph.GraphNodeRenderer;

public class JGraph
extends JPanel
implements Cloneable {
    protected Editor _editor;

    public JGraph() {
        this(new DefaultGraphModel());
    }

    public JGraph(Diagram d) {
        this(new Editor(d));
    }

    public JGraph(GraphModel gm) {
        this(new Editor(gm, null));
    }

    public JGraph(Editor ed) {
        super(false);
        this._editor = ed;
        this._editor.setAwtComponent(this);
        this.addMouseListener(this._editor);
        this.addMouseMotionListener(this._editor);
        this.addKeyListener(this._editor);
        this.initKeys();
    }

    public Object clone() {
        JGraph newJGraph = new JGraph((Editor)this._editor.clone());
        return newJGraph;
    }

    public void initKeys() {
        int shift = 1;
        int ctrl = 2;
        int ctrlShift = 3;
        int alt = 8;
        this.bindKey(new CmdSelectNext(true), 9, 0);
        this.bindKey(new CmdSelectNext(false), 9, shift);
        this.bindKey(new CmdReorder(3), 66, ctrl);
        this.bindKey(new CmdReorder(4), 70, ctrl);
        this.bindKey(new CmdReorder(1), 66, ctrlShift);
        this.bindKey(new CmdReorder(2), 70, ctrlShift);
        this.bindKey(new CmdNudge(1), 37, 0);
        this.bindKey(new CmdNudge(2), 39, 0);
        this.bindKey(new CmdNudge(3), 38, 0);
        this.bindKey(new CmdNudge(4), 40, 0);
        this.bindKey(new CmdNudge(1, 8), 37, shift);
        this.bindKey(new CmdNudge(2, 8), 39, shift);
        this.bindKey(new CmdNudge(3, 8), 38, shift);
        this.bindKey(new CmdNudge(4, 8), 40, shift);
    }

    public void bindKey(ActionListener action, int keyCode, int modifiers) {
        this.registerKeyboardAction(action, KeyStroke.getKeyStroke(keyCode, modifiers), 0);
    }

    public Editor getEditor() {
        return this._editor;
    }

    public void setDiagram(Diagram d) {
        if (d == null) {
            return;
        }
        this._editor.getLayerManager().replaceActiveLayer(d.getLayer());
        this._editor.setGraphModel(d.getGraphModel());
        this._editor.getSelectionManager().deselectAll();
        this._editor.damageAll();
    }

    public void setGraphModel(GraphModel gm) {
        this._editor.setGraphModel(gm);
    }

    public GraphModel getGraphModel() {
        return this._editor.getGraphModel();
    }

    public void setGraphNodeRenderer(GraphNodeRenderer r) {
        this._editor.setGraphNodeRenderer(r);
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._editor.getGraphNodeRenderer();
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer r) {
        this._editor.setGraphEdgeRenderer(r);
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._editor.getGraphEdgeRenderer();
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addGraphSelectionListener(GraphSelectionListener listener2) {
        this.getEditor().addGraphSelectionListener(listener2);
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener2) {
        this.getEditor().removeGraphSelectionListener(listener2);
    }

    public void layoutGraph() {
    }

    public void paint(Graphics g) {
        this._editor.paint(g);
    }

    public void select(Fig f) {
        if (f == null) {
            this.deselectAll();
        } else {
            this._editor.getSelectionManager().select(f);
        }
    }

    public void selectByOwner(Object owner) {
        Layer lay = this._editor.getLayerManager().getActiveLayer();
        if (lay instanceof LayerDiagram) {
            this.select(((LayerDiagram)lay).presentationFor(owner));
        }
    }

    public void deselect(Fig f) {
        this._editor.getSelectionManager().deselect(f);
    }

    public void toggleItem(Fig f) {
        this._editor.getSelectionManager().toggle(f);
    }

    public void deselectAll() {
        this._editor.getSelectionManager().deselectAll();
    }

    public void select(Vector items) {
        this._editor.getSelectionManager().select(items);
    }

    public void toggleItems(Vector items) {
        this._editor.getSelectionManager().toggle(items);
    }

    public Vector selectedFigs() {
        return this._editor.getSelectionManager().getFigs();
    }
}

