/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Point;
import java.awt.Rectangle;

public class Geometry {
    private static Point tempPoint = new Point(0, 0);
    private static Rectangle tempRect1 = new Rectangle();
    private static Rectangle tempRect2 = new Rectangle();

    public static void ptClosestTo(Rectangle r, Point p, Point res) {
        int x1 = Math.min(r.x, r.x + r.width);
        int y1 = Math.min(r.y, r.y + r.height);
        int x2 = Math.max(r.x, r.x + r.width);
        int y2 = Math.max(r.y, r.y + r.height);
        int c = 0;
        c = p.x < x1 ? 0 : (p.x > x2 ? 2 : 1);
        c = p.y < y1 ? (c += 0) : (p.y > y2 ? (c += 6) : (c += 3));
        switch (c) {
            case 0: {
                res.x = x1;
                res.y = y1;
                return;
            }
            case 1: {
                res.x = p.x;
                res.y = y1;
                return;
            }
            case 2: {
                res.x = x2;
                res.y = y1;
                return;
            }
            case 3: {
                res.x = x1;
                res.y = p.y;
                return;
            }
            case 4: {
                res.x = p.x;
                res.y = p.y;
                return;
            }
            case 5: {
                res.x = x2;
                res.y = p.y;
                return;
            }
            case 6: {
                res.x = x1;
                res.y = y2;
                return;
            }
            case 7: {
                res.x = p.x;
                res.y = y2;
                return;
            }
            case 8: {
                res.x = x2;
                res.y = y2;
                return;
            }
        }
    }

    public static Point ptClosestTo(Rectangle r, Point p) {
        Point res = new Point(0, 0);
        Geometry.ptClosestTo(r, p, res);
        return res;
    }

    public static double segmentAngle(Point p1, Point p2) {
        if (p2.x == p1.x && p2.y <= p1.y) {
            return 90.0;
        }
        if (p2.x == p1.x && p2.y > p1.y) {
            return 270.0;
        }
        if (p2.y == p1.y && p2.x > p1.x) {
            return 0.0;
        }
        if (p2.y == p1.y) {
            return 180.0;
        }
        int dx = p2.x - p1.x;
        int dy = p2.y = p1.y;
        double m = dy / dx;
        double a = Math.atan(m);
        if (dx > 0) {
            return a;
        }
        return -a;
    }

    public static void ptClosestTo(int x1, int y1, int x2, int y2, Point p, Point res) {
        if (y1 == y2 && x1 == x1) {
            res.x = x1;
            res.y = y1;
            return;
        }
        if (y1 == y2) {
            res.y = y1;
            res.x = Geometry.mid(x1, x2, p.x);
            return;
        }
        if (x1 == x2) {
            res.x = x1;
            res.y = Geometry.mid(y1, y2, p.y);
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        res.x = dy * (dy * x1 - dx * (y1 + p.y)) + dx * p.x;
        res.x /= dx * dx + dy * dy;
        res.y = dx * (p.x - res.x) / dy + p.y;
    }

    public static int mid(int a, int b, int c) {
        if (a <= b) {
            if (b <= c) {
                return b;
            }
            if (c <= a) {
                return a;
            }
            return c;
        }
        if (b >= c) {
            return b;
        }
        if (c >= a) {
            return a;
        }
        return c;
    }

    public static Point ptClosestTo(int x1, int y1, int x2, int y2, Point p) {
        Point res = new Point(0, 0);
        Geometry.ptClosestTo(x1, y1, x2, y2, p, res);
        return res;
    }

    public static Point ptClosestTo(Point p1, Point p2, Point p) {
        return Geometry.ptClosestTo(p1.x, p1.y, p2.x, p2.y, p);
    }

    public static synchronized void ptClosestTo(int[] xs, int[] ys, int n, Point p, Point res) {
        res.x = xs[0];
        res.y = ys[0];
        int bestDist = (res.x - p.x) * (res.x - p.x) + (res.y - p.y) * (res.y - p.y);
        Geometry.tempPoint.x = 0;
        Geometry.tempPoint.y = 0;
        for (int i = 0; i < n - 1; ++i) {
            Geometry.ptClosestTo(xs[i], ys[i], xs[i + 1], ys[i + 1], p, tempPoint);
            int tDist = (Geometry.tempPoint.x - res.x) * (Geometry.tempPoint.x - res.x) + (Geometry.tempPoint.y - res.y) * (Geometry.tempPoint.y - res.y);
            if (bestDist <= tDist) continue;
            bestDist = tDist;
            res.x = Geometry.tempPoint.x;
            res.y = Geometry.tempPoint.y;
        }
    }

    public static Point ptClosestTo(int[] xs, int[] ys, int n, Point p) {
        Point res = new Point(0, 0);
        Geometry.ptClosestTo(xs, ys, n, p, res);
        return res;
    }

    public static synchronized boolean nearPolySegment(int[] xs, int[] ys, int n, int x, int y, int grip) {
        for (int i = 0; i < n - 1; ++i) {
            int x1 = xs[i];
            int y1 = ys[i];
            int x2 = xs[i + 1];
            int y2 = ys[i + 1];
            if (!Geometry.nearSegment(x1, y1, x2, y2, x, y, grip)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean nearSegment(int x1, int y1, int x2, int y2, int x, int y, int grip) {
        tempRect1.setBounds(x - grip, y - grip, 2 * grip, 2 * grip);
        return Geometry.intersects(tempRect1, x1, y1, x2, y2);
    }

    public static synchronized boolean intersects(Rectangle r, int x1, int y1, int x2, int y2) {
        tempRect2.setBounds(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
        if (!r.intersects(tempRect2)) {
            return false;
        }
        int ccw1 = Geometry.counterClockWise(x1, y1, x2, y2, r.x, r.y);
        int ccw2 = Geometry.counterClockWise(x1, y1, x2, y2, r.x, r.y + r.height);
        int ccw3 = Geometry.counterClockWise(x1, y1, x2, y2, r.x + r.width, r.y);
        int ccw4 = Geometry.counterClockWise(x1, y1, x2, y2, r.x + r.width, r.y + r.height);
        return (ccw1 == 1 || ccw2 == 1 || ccw3 == 1 || ccw4 == 1) && (ccw1 == -1 || ccw2 == -1 || ccw3 == -1 || ccw4 == -1) || ccw1 == 0 || ccw2 == 0 || ccw3 == 0 || ccw4 == 0;
    }

    public static int counterClockWise(int x1, int y1, int x2, int y2, int x, int y) {
        int dx1 = x2 - x1;
        int dy2 = y - y1;
        int dy1 = y2 - y1;
        int dx2 = x - x1;
        if (dx1 * dy2 > dy1 * dx2) {
            return 1;
        }
        if (dx1 * dy2 < dy1 * dx2) {
            return -1;
        }
        if (dx1 * dx2 < 0 || dy1 * dy2 < 0) {
            return -1;
        }
        if (dx1 * dx1 + dy1 * dy1 < dx2 * dx2 + dy2 * dy2) {
            return 1;
        }
        return 0;
    }
}

