/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import uci.gef.Fig;
import uci.gef.Geometry;

public class FigLine
extends Fig {
    protected int _x1;
    protected int _y1;
    protected int _x2;
    protected int _y2;

    public FigLine(int x1, int y1, int x2, int y2, Color lineColor) {
        this.setX1(x1);
        this.setY1(y1);
        this.setX2(x2);
        this.setY2(y2);
        this.setLineColor(lineColor);
        this.calcBounds();
    }

    public FigLine(int x1, int y1, int x2, int y2) {
        this.setX1(x1);
        this.setY1(y1);
        this.setX2(x2);
        this.setY2(y2);
        this.calcBounds();
    }

    public final void setShape(Point p1, Point p2) {
        this.setShape(p1.x, p1.y, p2.x, p2.y);
    }

    public void setShape(int x1, int y1, int x2, int y2) {
        this._x1 = x1;
        this._y1 = y1;
        this._x2 = x2;
        this._y2 = y2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setX1(int x1) {
        this._x1 = x1;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY1(int y1) {
        this._y1 = y1;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setX2(int x2) {
        this._x2 = x2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY2(int y2) {
        this._y2 = y2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public boolean isResizable() {
        return false;
    }

    public boolean isReshapable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    public void setPoints(Point[] ps) {
        if (ps.length != 2) {
            throw new IllegalArgumentException("FigLine must have exactly 2 points");
        }
        this._x1 = ps[0].x;
        this._y1 = ps[0].y;
        this._x2 = ps[1].x;
        this._y2 = ps[1].y;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public Point[] getPoints() {
        Point[] ps = new Point[]{new Point(this._x1, this._y1), new Point(this._x2, this._y2)};
        return ps;
    }

    public void setPoints(int i, int x, int y) {
        if (i == 0) {
            this._x1 = x;
            this._y1 = y;
        } else if (i == 1) {
            this._x2 = x;
            this._y2 = y;
        } else {
            throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
        }
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public Point getPoints(int i) {
        if (i == 0) {
            return new Point(this._x1, this._y1);
        }
        if (i == 1) {
            return new Point(this._x2, this._y2);
        }
        throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
    }

    public int getNumPoints() {
        return 2;
    }

    public int[] getXs() {
        int[] xs = new int[]{this._x1, this._x2};
        return xs;
    }

    public int[] getYs() {
        int[] ys = new int[]{this._y1, this._y2};
        return ys;
    }

    public int getPerimeterLength() {
        int dxdx = (this._x2 - this._x1) * (this._x2 - this._x1);
        int dydy = (this._y2 - this._y1) * (this._y2 - this._y1);
        return (int)Math.sqrt(dxdx + dydy);
    }

    public Point pointAlongPerimeter(int dist) {
        int len = this.getPerimeterLength();
        if (len == 0) {
            return new Point(this._x1, this._y1);
        }
        int p = Math.min(dist, len);
        return new Point(this._x1 + (this._x2 - this._x1) * p / len, this._y1 + (this._y2 - this._y1) * p / len);
    }

    public void setBounds(int x, int y, int w, int h) {
        this._x1 = this._w == 0 ? x : x + (this._x1 - this._x) * w / this._w;
        this._y1 = this._h == 0 ? y : y + (this._y1 - this._y) * h / this._h;
        this._x2 = this._w == 0 ? x : x + (this._x2 - this._x) * w / this._w;
        this._y2 = this._h == 0 ? y : y + (this._y2 - this._y) * h / this._h;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public Point connectionPoint(Point anotherPt) {
        return Geometry.ptClosestTo(this._x1, this._y1, this._x2, this._y2, anotherPt);
    }

    public void translate(int dx, int dy) {
        this._x1 += dx;
        this._y1 += dy;
        this._x2 += dx;
        this._y2 += dy;
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", null, null);
    }

    public void calcBounds() {
        if (this._x1 < this._x2) {
            this._x = this._x1;
            this._w = this._x2 - this._x1;
        } else {
            this._x = this._x2;
            this._w = this._x1 - this._x2;
        }
        if (this._y1 < this._y2) {
            this._y = this._y1;
            this._h = this._y2 - this._y1;
        } else {
            this._y = this._y2;
            this._h = this._y1 - this._y2;
        }
    }

    public void paint(Graphics g) {
        if (this._lineWidth > 0) {
            g.setColor(this._lineColor);
            g.drawLine(this._x1, this._y1, this._x2, this._y2);
        }
    }

    public boolean hit(Rectangle r) {
        return Geometry.intersects(r, this._x1, this._y1, this._x2, this._y2);
    }

    public boolean intersects(Rectangle r) {
        return Geometry.intersects(r, this._x1, this._y1, this._x2, this._y2);
    }

    public void createDrag(int anchorX, int anchorY, int x, int y, int snapX, int snapY) {
        this._x2 = snapX;
        this._y2 = snapY;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }
}

