/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import uci.gef.ArrowHead;
import uci.gef.ArrowHeadNone;
import uci.gef.Fig;
import uci.gef.FigNode;
import uci.gef.Handle;
import uci.gef.PathConv;
import uci.graph.GraphEdgeHooks;

public abstract class FigEdge
extends Fig
implements PropertyChangeListener {
    protected Fig _sourcePortFig;
    protected Fig _destPortFig;
    protected FigNode _sourceFigNode;
    protected FigNode _destFigNode;
    protected Fig _fig;
    protected boolean _useNearest = false;
    protected boolean _highlight = false;
    protected ArrowHead _arrowHeadStart = new ArrowHeadNone();
    protected ArrowHead _arrowHeadEnd = new ArrowHeadNone();
    protected Vector _pathItems = new Vector();

    public FigEdge(Fig s, Fig d, FigNode sfn, FigNode dfn, Object edge) {
        this._sourcePortFig = s;
        this._destPortFig = d;
        this.sourceFigNode(sfn);
        this.destFigNode(dfn);
        this.setOwner(edge);
        this._fig = this.makeEdgeFig();
    }

    public FigEdge() {
        this._fig = this.makeEdgeFig();
    }

    protected abstract Fig makeEdgeFig();

    public Fig getFig() {
        return this._fig;
    }

    public void sourcePortFig(Fig fig) {
        this._sourcePortFig = fig;
    }

    public void destPortFig(Fig fig) {
        this._destPortFig = fig;
    }

    public void sourceFigNode(FigNode fn) {
        if (this._sourceFigNode != null) {
            this._sourceFigNode.removeFigEdge(this);
        }
        this._sourceFigNode = fn;
        fn.addFigEdge(this);
    }

    public void destFigNode(FigNode fn) {
        if (this._destFigNode != null) {
            this._destFigNode.removeFigEdge(this);
        }
        this._destFigNode = fn;
        fn.addFigEdge(this);
    }

    public void setOwner(Object own) {
        Object oldOwner = this.getOwner();
        if (oldOwner != null && oldOwner instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)oldOwner).removePropertyChangeListener(this);
        }
        if (own instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)own).addPropertyChangeListener(this);
        }
        super.setOwner(own);
    }

    public ArrowHead getSourceArrowHead() {
        return this._arrowHeadStart;
    }

    public ArrowHead getDestArrowHead() {
        return this._arrowHeadEnd;
    }

    public void setSourceArrowHead(ArrowHead newArrow) {
        this._arrowHeadStart = newArrow;
    }

    public void setDestArrowHead(ArrowHead newArrow) {
        this._arrowHeadEnd = newArrow;
    }

    public Vector getPathItemsRaw() {
        return this._pathItems;
    }

    public Fig getPathItem(PathConv pointOnPath) {
        return null;
    }

    public void addPathItem(Fig newFig, PathConv newPath) {
        this._pathItems.addElement(new PathItem(this, newFig, newPath));
    }

    public void removePathItem(PathItem goneItem) {
        this._pathItems.removeElement(goneItem);
    }

    public boolean getBetweenNearestPoints() {
        return this._useNearest;
    }

    public void setBetweenNearestPoints(boolean un) {
        this._useNearest = un;
    }

    protected void computeRoute() {
    }

    public Rectangle getBounds() {
        return this._fig.getBounds();
    }

    protected void calcBounds() {
        this._fig.calcBounds();
        this._x = this._fig.getX();
        this._y = this._fig.getY();
        this._w = this._fig.getWidth();
        this._h = this._fig.getHeight();
    }

    public boolean contains(int x, int y) {
        return this._fig.contains(x, y);
    }

    public boolean intersects(Rectangle r) {
        return this._fig.intersects(r);
    }

    public boolean hit(Rectangle r) {
        return this._fig.hit(r);
    }

    public int getPerimeterLength() {
        return this._fig.getPerimeterLength();
    }

    public Point pointAlongPerimeter(int dist) {
        return this._fig.pointAlongPerimeter(dist);
    }

    public void setPoints(Point[] ps) {
        this._fig.setPoints(ps);
        this.calcBounds();
    }

    public Point[] getPoints() {
        return this._fig.getPoints();
    }

    public void setPoints(int i, int x, int y) {
        this._fig.setPoints(i, x, y);
        this.calcBounds();
    }

    public void setPoints(Handle h, int x, int y) {
        this._fig.setPoints(h, x, y);
        this.calcBounds();
    }

    public Point getPoints(int i) {
        return this._fig.getPoints(i);
    }

    public int getNumPoints() {
        return this._fig.getNumPoints();
    }

    public void setNumPoints(int npoints) {
        this._fig.setNumPoints(npoints);
        this.calcBounds();
    }

    public int[] getXs() {
        return this._fig.getXs();
    }

    public void setXs(int[] xs) {
        this._fig.setXs(xs);
        this.calcBounds();
    }

    public int[] getYs() {
        return this._fig.getYs();
    }

    public void setYs(int[] ys) {
        this._fig.setYs(ys);
        this.calcBounds();
    }

    public boolean isResizable() {
        return this._fig.isResizable();
    }

    public boolean isReshapable() {
        return this._fig.isReshapable();
    }

    public boolean isRotatable() {
        return this._fig.isRotatable();
    }

    protected void paintArrowHeads(Graphics g) {
        this._arrowHeadStart.paint(g, this.pointAlongPerimeter(5), this.pointAlongPerimeter(0));
        this._arrowHeadEnd.paint(g, this.pointAlongPerimeter(this.getPerimeterLength() - 6), this.pointAlongPerimeter(this.getPerimeterLength() - 1));
    }

    protected void paintPathItems(Graphics g) {
        Vector pathVec = this.getPathItemsRaw();
        for (int i = 0; i < pathVec.size(); ++i) {
            PathItem element = (PathItem)pathVec.elementAt(i);
            PathConv path = element.getPath();
            Fig f = element.getFig();
            f.setLocation(path.getPoint().x, path.getPoint().y);
            f.paint(g);
        }
    }

    public void paint(Graphics g) {
        this.computeRoute();
        this._fig.paint(g);
        this.paintArrowHeads(g);
        this.paintPathItems(g);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        System.out.println("FigEdge got a PropertyChangeEvent");
        String pName = pce.getPropertyName();
        Object src = pce.getSource();
        if (pName.equals("Dispose") && src == this.getOwner()) {
            this.delete();
        }
        if (pName.equals("Highlight") && src == this.getOwner()) {
            this._highlight = (Boolean)pce.getNewValue();
            this.damage();
        }
    }

    protected class PathItem {
        Fig _fig;
        PathConv _path;

        PathItem(FigEdge this$0, Fig f, PathConv pc) {
            this._fig = f;
            this._path = pc;
        }

        PathConv getPath() {
            return this._path;
        }

        Fig getFig() {
            return this._fig;
        }
    }
}

