/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Graphics;
import uci.gef.Fig;

public class FigCircle
extends Fig {
    public static final double CIRCLE_ADJUST_RADIUS = 0.1;

    public FigCircle(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public FigCircle(int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
    }

    public void paint(Graphics g) {
        if (this._filled && this._fillColor != null) {
            g.setColor(this._fillColor);
            g.fillOval(this._x, this._y, this._w, this._h);
        }
        if (this._lineWidth > 0 && this._lineColor != null) {
            g.setColor(this._lineColor);
            g.drawOval(this._x, this._y, this._w - this._lineWidth, this._h - this._lineWidth);
        }
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        double dx = (double)(this._x + this._w / 2 - x) * (double)2 / (double)this._w;
        double dy = (double)(this._y + this._h / 2 - y) * (double)2 / (double)this._h;
        double distSquared = dx * dx + dy * dy;
        return distSquared <= 1.01;
    }

    static {
        CIRCLE_ADJUST_RADIUS = 0.1;
    }
}

