/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import uci.gef.Editor;
import uci.gef.Geometry;
import uci.gef.Globals;
import uci.gef.Handle;
import uci.gef.Layer;
import uci.gef.RedrawManager;
import uci.graph.GraphEdgeHooks;
import uci.graph.GraphNodeHooks;
import uci.graph.GraphPortHooks;
import uci.ui.PropCategoryManager;

public class Fig
implements Serializable {
    public final int MIN_SIZE = 4;
    public Vector arcos = new Vector();
    protected Layer _layer = null;
    protected boolean _locked = false;
    private Object _owner;
    protected int _x;
    protected int _y;
    protected int _w;
    protected int _h;
    protected Color _lineColor = Color.black;
    protected Color _fillColor = Color.white;
    protected int _lineWidth = 1;
    protected boolean _filled = true;
    public final int BORDER = 8;

    public Fig(int x, int y, int w, int h, Color lineColor, Color fillColor, Object own) {
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        if (this._lineColor != null) {
            this._lineColor = lineColor;
        } else {
            this._lineWidth = 0;
        }
        if (this._fillColor != null) {
            this._fillColor = fillColor;
        } else {
            this._filled = false;
        }
        this.setOwner(own);
    }

    public Fig(int x, int y, int w, int h, Color lineColor, Color fillColor) {
        this(x, y, w, h, lineColor, fillColor, null);
    }

    public Fig(int x, int y, int w, int h) {
        this(x, y, w, h, Color.black, Color.white, null);
    }

    public Fig() {
    }

    public boolean OK() {
        return this._lineWidth >= 0 && this._lineColor != null && this._fillColor != null;
    }

    public void setLayer(Layer lay) {
        this.firePropChange("layer", this._layer, lay);
        this._layer = lay;
    }

    public Layer getLayer() {
        return this._layer;
    }

    public void setLocked(boolean b) {
        this.firePropChange("locked", this._locked, b);
        this._locked = b;
    }

    public boolean getLocked() {
        return this._locked;
    }

    public void setOwner(Object own) {
        this.firePropChange("owner", this._owner, own);
        this._owner = own;
    }

    public Object getOwner() {
        return this._owner;
    }

    public void setLineColor(Color col) {
        if (col != null) {
            this.firePropChange("lineColor", this._lineColor, col);
            this._lineColor = col;
        } else {
            this.firePropChange("lineWidth", this._lineWidth, 0);
            this._lineWidth = 0;
        }
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public void setFillColor(Color col) {
        if (col != null) {
            this.firePropChange("fillColor", this._fillColor, col);
            this._fillColor = col;
        } else {
            this.firePropChange("filled", this._filled, false);
            this._filled = false;
        }
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public void setFilled(boolean f) {
        this.firePropChange("filled", this._filled, f);
        this._filled = f;
    }

    public boolean getFilled() {
        return this._filled;
    }

    public void setLineWidth(int w) {
        int newLW = Math.max(0, Math.min(1, w));
        this.firePropChange("lineWidth", this._lineWidth, newLW);
        this._lineWidth = newLW;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        g.setColor(Color.pink);
        g.fillRect(this._x, this._y, this._w, this._h);
        g.setColor(Color.black);
        g.drawString("(undefined)", this._x + this._w / 2, this._y + this._h / 2);
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._w, this._h);
    }

    public void stuffBounds(Rectangle r) {
        r.setBounds(this._x, this._y, this._w, this._h);
    }

    public final void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void delete() {
        if (this._layer != null) {
            this._layer.deleted(this);
        }
        this.setOwner(null);
    }

    public void dispose() {
        Object own = this.getOwner();
        if (own instanceof GraphNodeHooks) {
            ((GraphNodeHooks)own).dispose();
        }
        if (own instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)own).dispose();
        }
        if (own instanceof GraphPortHooks) {
            ((GraphPortHooks)own).dispose();
        } else {
            this.delete();
        }
    }

    public boolean isMovable() {
        return true;
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isReshapable() {
        return false;
    }

    public boolean isRotatable() {
        return false;
    }

    public void damage() {
        if (this._layer != null) {
            this._layer.damaged(this);
        }
    }

    public void startTrans() {
        this.damage();
        RedrawManager.lock();
    }

    public void endTrans() {
        this.damage();
        RedrawManager.unlock();
    }

    public Rectangle routingRect() {
        return new Rectangle(this._x - 8, this._y - 8, this._w + 16, this._h + 16);
    }

    public void reorder(int func, Layer lay) {
        lay.reorder(this, func);
    }

    public void translate(int dx, int dy) {
        Rectangle oldBounds = this.getBounds();
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public final void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.translate(x - this._x, y - this._y);
    }

    public Point getLocation() {
        return new Point(this._x, this._y);
    }

    public Dimension getSize() {
        return new Dimension(this._w, this._h);
    }

    public final void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        this.setBounds(this._x, this._y, w, h);
    }

    public Dimension getMinimumSize() {
        return new Dimension(4, 4);
    }

    public Dimension getPreferedSize() {
        return new Dimension(this._w, this._h);
    }

    public void setX(int x) {
        this.setBounds(x, this._y, this._w, this._h);
    }

    public int getX() {
        return this._x;
    }

    public void setY(int y) {
        this.setBounds(this._x, y, this._w, this._h);
    }

    public int getY() {
        return this._y;
    }

    public void setWidth(int w) {
        this.setBounds(this._x, this._y, w, this._h);
    }

    public int getWidth() {
        return this._w;
    }

    public void setHeight(int h) {
        this.setBounds(this._x, this._y, this._w, h);
    }

    public int getHeight() {
        return this._h;
    }

    public void setPoints(Point[] ps) {
    }

    public Point[] getPoints() {
        return new Point[0];
    }

    public final void setPoints(int i, Point p) {
        this.setPoints(i, p.x, p.y);
    }

    public final void setPoints(Handle h, Point p) {
        this.setPoints(h, p.x, p.y);
    }

    public void setPoints(int i, int x, int y) {
    }

    public void setPoints(Handle h, int x, int y) {
        this.setPoints(h.index, x, y);
    }

    public Point getPoints(int i) {
        return null;
    }

    public int getNumPoints() {
        return 0;
    }

    public void setNumPoints(int npoints) {
    }

    public int[] getXs() {
        return new int[0];
    }

    public void setXs(int[] xs) {
    }

    public int[] getYs() {
        return new int[0];
    }

    public void setYs(int[] ys) {
    }

    public void addPoint(int x, int y) {
    }

    public void insertPoint(int i, int x, int y) {
    }

    public void removePoint(int i) {
    }

    public int getPerimeterLength() {
        return this._w + this._w + this._h + this._h;
    }

    public Point pointAlongPerimeter(int dist) {
        if (dist < this._w && dist >= 0) {
            return new Point(this._x + dist, this._y);
        }
        if (dist < this._w + this._h) {
            return new Point(this._x + this._w, this._y + (dist - this._w));
        }
        if (dist < this._w + this._h + this._w) {
            return new Point(this._x + this._w - (dist - this._w - this._h), this._y + this._h);
        }
        if (dist < this._w + this._h + this._w + this._h) {
            return new Point(this._x, this._y + (this._w + this._h + this._w + this._h - dist));
        }
        return new Point(this._x, this._y);
    }

    public void align(Rectangle r, int direction, Editor ed) {
        Rectangle bbox = this.getBounds();
        int dx = 0;
        int dy = 0;
        switch (direction) {
            case 0: {
                dy = r.y - bbox.y;
                break;
            }
            case 1: {
                dy = r.y + r.height - (bbox.y + bbox.height);
                break;
            }
            case 2: {
                dx = r.x - bbox.x;
                break;
            }
            case 3: {
                dx = r.x + r.width - (bbox.x + bbox.width);
                break;
            }
            case 4: {
                dx = r.x + r.width / 2 - (bbox.x + bbox.width / 2);
                dy = r.y + r.height / 2 - (bbox.y + bbox.height / 2);
                break;
            }
            case 5: {
                dx = r.x + r.width / 2 - (bbox.x + bbox.width / 2);
                break;
            }
            case 6: {
                dy = r.y + r.height / 2 - (bbox.y + bbox.height / 2);
                break;
            }
            case 7: {
                Point loc = this.getLocation();
                Point snapPt = new Point(loc.x, loc.y);
                ed.snap(snapPt);
                dx = snapPt.x - loc.x;
                dy = snapPt.y - loc.y;
            }
        }
        this.translate(dx, dy);
    }

    public boolean contains(int x, int y) {
        return this._x <= x && x <= this._x + this._w && this._y <= y && y <= this._y + this._h;
    }

    public final boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(Rectangle r) {
        return this.countCornersContained(r.x, r.y, r.width, r.height) == 4;
    }

    public boolean within(Rectangle r) {
        return r.contains(this._x, this._y) && r.contains(this._x + this._w, this._y + this._h);
    }

    public boolean hit(Rectangle r) {
        int cornersHit = this.countCornersContained(r.x, r.y, r.width, r.height);
        if (this._filled) {
            return cornersHit > 0;
        }
        return cornersHit > 0 && cornersHit < 4;
    }

    protected int countCornersContained(int x, int y, int w, int h) {
        int cornersHit = 0;
        if (this.contains(x, y)) {
            ++cornersHit;
        }
        if (this.contains(x + w, y)) {
            ++cornersHit;
        }
        if (this.contains(x, y + h)) {
            ++cornersHit;
        }
        if (this.contains(x + w, y + h)) {
            ++cornersHit;
        }
        return cornersHit;
    }

    public boolean intersects(Rectangle r) {
        return this.getBounds().intersects(r);
    }

    public Point center() {
        Rectangle bbox = this.getBounds();
        return new Point(bbox.x + bbox.width / 2, bbox.y + bbox.height / 2);
    }

    public Point connectionPoint(Point anotherPt) {
        return Geometry.ptClosestTo(this.getBounds(), anotherPt);
    }

    public void createDrag(int anchorX, int anchorY, int x, int y, int snapX, int snapY) {
        int newX = Math.min(anchorX, snapX);
        int newY = Math.min(anchorY, snapY);
        int newW = Math.max(anchorX, snapX) - newX;
        int newH = Math.max(anchorY, snapY) - newY;
        this.setBounds(newX, newY, newW, newH);
    }

    protected void calcBounds() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        Globals.addPropertyChangeListener(this, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        Globals.removePropertyChangeListener(this, l);
    }

    protected void firePropChange(String propName, Object oldV, Object newV) {
        Globals.firePropChange((Object)this, propName, oldV, newV);
    }

    protected void firePropChange(String propName, int oldV, int newV) {
        Globals.firePropChange((Object)this, propName, new Integer(oldV), new Integer(newV));
    }

    protected void firePropChange(String propName, boolean oldV, boolean newV) {
        Globals.firePropChange((Object)this, propName, new Boolean(oldV), new Boolean(newV));
    }

    static {
        PropCategoryManager.categorizeProperty("Geometry", "x");
        PropCategoryManager.categorizeProperty("Geometry", "y");
        PropCategoryManager.categorizeProperty("Geometry", "width");
        PropCategoryManager.categorizeProperty("Geometry", "height");
        PropCategoryManager.categorizeProperty("Geometry", "filled");
        PropCategoryManager.categorizeProperty("Geometry", "locked");
        PropCategoryManager.categorizeProperty("Style", "lineWidth");
        PropCategoryManager.categorizeProperty("Style", "fillColor");
        PropCategoryManager.categorizeProperty("Style", "lineColor");
        PropCategoryManager.categorizeProperty("Style", "filled");
    }
}

