/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import uci.gef.Cmd;
import uci.gef.Editor;
import uci.gef.Globals;
import uci.gef.LayerManager;
import uci.gef.SelectionManager;

public class CmdReorder
extends Cmd {
    public static final int SEND_TO_BACK = 1;
    public static final int BRING_TO_FRONT = 2;
    public static final int SEND_BACKWARD = 3;
    public static final int BRING_FORWARD = 4;
    private int function;

    public CmdReorder(int f) {
        super(CmdReorder.wordFor(f));
        this.function = f;
    }

    protected static String wordFor(int f) {
        switch (f) {
            case 3: {
                return "Atr\u00e1s";
            }
            case 1: {
                return "Al Fondo";
            }
            case 4: {
                return "Adelante";
            }
            case 2: {
                return "Al Frente";
            }
        }
        return "";
    }

    public void doIt() {
        Editor ce = Globals.curEditor();
        LayerManager lm = ce.getLayerManager();
        SelectionManager sm = ce.getSelectionManager();
        sm.startTrans();
        sm.reorder(this.function, lm.getActiveLayer());
        sm.endTrans();
        ce.repairDamage();
    }

    public void undoIt() {
        System.out.println("Connot undo CmdReorder, yet");
    }

    static {
        SEND_TO_BACK = 1;
        BRING_TO_FRONT = 2;
        SEND_BACKWARD = 3;
        BRING_FORWARD = 4;
    }
}

