/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import uci.gef.Cmd;
import uci.gef.Editor;
import uci.gef.Globals;
import uci.gef.JGraphFrame;

public class CmdOpen
extends Cmd
implements FilenameFilter {
    public CmdOpen() {
        super("Open...");
    }

    public CmdOpen(String filterPattern) {
        this();
        this.setArg("filterPattern", filterPattern);
    }

    public void doIt() {
        try {
            Editor ce = Globals.curEditor();
            FileDialog fd = new FileDialog(ce.findFrame(), "Open...", 0);
            fd.setFilenameFilter(this);
            fd.setDirectory(".");
            fd.show();
            String filename = fd.getFile();
            String path = fd.getDirectory();
            if (filename != null) {
                Globals.showStatus(String.valueOf(String.valueOf(new StringBuffer("Reading ").append(path).append(filename).append("..."))));
                FileInputStream fis = new FileInputStream(String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(filename))));
                ObjectInputStream s = new ObjectInputStream(fis);
                Editor ed = (Editor)s.readObject();
                ed.postLoad();
                if (fis != null) {
                    fis.close();
                }
                Globals.showStatus(String.valueOf(String.valueOf(new StringBuffer("Read ").append(path).append(filename))));
                JGraphFrame jgf = new JGraphFrame(String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(filename))), ed);
                Object d = this.getArg("dimension");
                if (d instanceof Dimension) {
                    ((Component)jgf).setSize((Dimension)d);
                }
                jgf.setVisible(true);
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (ClassNotFoundException ignore) {
            System.out.println("got an ClassNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
        }
    }

    public boolean accept(File dir, String name) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("checking: ").append(dir).append(" ").append(name))));
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdOpen");
    }
}

