/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import uci.gef.Cmd;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Selection;
import uci.gef.SelectionManager;

public class CmdInsertPoint
extends Cmd {
    protected int _selectedHandle = 0;

    public CmdInsertPoint(int i) {
        this();
        this._selectedHandle = i;
    }

    public CmdInsertPoint() {
        super("Insert a new point");
    }

    public void doIt() {
        int newY;
        int newX;
        Fig f = null;
        Selection sel = null;
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        if (sm.selections().isEmpty()) {
            return;
        }
        sel = (Selection)sm.selections().firstElement();
        f = sel.getContent();
        int npoints = f.getNumPoints();
        int[] xs = f.getXs();
        int[] ys = f.getYs();
        if (this._selectedHandle == npoints - 1) {
            newX = (xs[this._selectedHandle] + xs[this._selectedHandle - 1]) / 2;
            newY = (ys[this._selectedHandle] + ys[this._selectedHandle - 1]) / 2;
        } else {
            newX = (xs[this._selectedHandle] + xs[this._selectedHandle + 1]) / 2;
            newY = (ys[this._selectedHandle] + ys[this._selectedHandle + 1]) / 2;
        }
        f.startTrans();
        f.insertPoint(this._selectedHandle, newX, newY);
        f.endTrans();
    }

    public void undoIt() {
        System.out.println("this operation currently cannot be undone");
    }
}

