/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import uci.gef.Cmd;
import uci.gef.Editor;
import uci.gef.Globals;
import uci.gef.SelectionManager;

public class CmdAlign
extends Cmd {
    public static final int ALIGN_TOPS = 0;
    public static final int ALIGN_BOTTOMS = 1;
    public static final int ALIGN_LEFTS = 2;
    public static final int ALIGN_RIGHTS = 3;
    public static final int ALIGN_CENTERS = 4;
    public static final int ALIGN_H_CENTERS = 5;
    public static final int ALIGN_V_CENTERS = 6;
    public static final int ALIGN_TO_GRID = 7;
    protected int direction;

    public CmdAlign(int dir) {
        super("Align ".concat(String.valueOf(String.valueOf(CmdAlign.wordFor(dir)))));
        this.direction = dir;
    }

    protected static String wordFor(int d) {
        switch (d) {
            case 0: {
                return "Tops";
            }
            case 1: {
                return "Bottoms";
            }
            case 2: {
                return "Left";
            }
            case 3: {
                return "Rights";
            }
            case 4: {
                return "Centers";
            }
            case 5: {
                return "Horizontal Centers";
            }
            case 6: {
                return "Vertical Centers";
            }
            case 7: {
                return "To Grid";
            }
        }
        return "";
    }

    public void doIt() {
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        sm.startTrans();
        sm.align(this.direction);
        sm.endTrans();
    }

    public void undoIt() {
    }

    static {
        ALIGN_TOPS = 0;
        ALIGN_BOTTOMS = 1;
        ALIGN_LEFTS = 2;
        ALIGN_RIGHTS = 3;
        ALIGN_CENTERS = 4;
        ALIGN_H_CENTERS = 5;
        ALIGN_V_CENTERS = 6;
        ALIGN_TO_GRID = 7;
    }
}

