/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import uci.gef.ArrowHead;

public class ArrowHeadTriangle
extends ArrowHead {
    public void paint(Graphics g, Point start, Point end) {
        int xTo = end.x;
        int xFrom = start.x;
        double dx = xTo - xFrom;
        int yTo = end.y;
        int yFrom = start.y;
        double dy = yTo - yFrom;
        double denom = this.dist(dx, dy);
        if (denom == 0.0) {
            return;
        }
        double cos = (double)12 / denom;
        double sin = (double)7 / denom;
        double x = (double)xTo - cos * dx;
        double y = (double)yTo - cos * dy;
        int x1 = (int)(x - sin * dy);
        int y1 = (int)(y + sin * dx);
        int x2 = (int)(x + sin * dy);
        int y2 = (int)(y - sin * dx);
        Polygon triangle = new Polygon();
        triangle.addPoint(xTo, yTo);
        triangle.addPoint(x1, y1);
        triangle.addPoint(x2, y2);
        g.setColor(this.arrowFillColor);
        g.fillPolygon(triangle);
        g.setColor(this.arrowLineColor);
        g.drawPolygon(triangle);
    }

    private double dist(int x0, int y0, int x1, int y1) {
        double dx = x0 - x1;
        double dy = y0 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double dist(double dx, double dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }
}

