/*
 * Decompiled with CFR 0.152.
 */
package uci.beans.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uci.beans.editors.ColorEditor;
import uci.beans.editors.ColorTilePanel;

public class ColorPickerGrid
extends JPanel
implements ActionListener {
    protected ColorTilePanel _tiles = new ColorTilePanel(36);
    protected ColorEditor _peColor = null;
    protected static ColorPickerGrid _theInstance = null;
    protected JLabel _statusLabel = new JLabel("No color selected");

    public ColorPickerGrid(Color orig) {
        this.setLayout(new BorderLayout());
        this._statusLabel.setFont(new Font("Courier", 0, 10));
        this.add((Component)this._tiles, "Center");
        this.add((Component)this._statusLabel, "South");
        this._tiles.setColor(orig);
        this._tiles.addActionListener(this);
    }

    public void setPEColor(ColorEditor pec) {
        this._peColor = pec;
        if (this._peColor != null) {
            this._tiles.allowSelection(true);
            this.setColor((Color)this._peColor.getValue());
        } else {
            this._tiles.allowSelection(false);
            this.updateStatusLabel();
        }
    }

    public void setColor(Color c) {
        this._tiles.setColor(c);
        this.updateStatusLabel();
    }

    public void actionPerformed(ActionEvent ae) {
        this.updateStatusLabel();
        if (this._peColor != null) {
            this._peColor.setValue(this._tiles.getColor());
        }
    }

    public void updateStatusLabel() {
        if (this._peColor == null) {
            this._statusLabel.setText("No color selected");
            return;
        }
        Color c = this._tiles.getColor();
        String r = Integer.toString(c.getRed(), 16).toUpperCase();
        String b = Integer.toString(c.getBlue(), 16).toUpperCase();
        String g = Integer.toString(c.getGreen(), 16).toUpperCase();
        if (c.getRed() == 0) {
            r = "00";
        }
        if (c.getBlue() == 0) {
            b = "00";
        }
        if (c.getGreen() == 0) {
            g = "00";
        }
        this._statusLabel.setText(String.valueOf(String.valueOf(new StringBuffer("Red:").append(r).append(" Blue:").append(b).append(" Green:").append(g))));
    }
}

