/*
 * Decompiled with CFR 0.152.
 */
package uci.beans.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JPanel;
import uci.beans.editors.ColorPickerGrid;

public class ColorEditor
extends JPanel
implements PropertyEditor {
    public Color _color = Color.white;
    private Vector listeners;

    public ColorEditor() {
        this.setLayout(null);
        this.resize(this.insets().left + this.insets().right + 20, this.insets().top + this.insets().bottom + 20);
        this.setForeground(Color.lightGray);
    }

    public void setValue(Object c) {
        if (!(c instanceof Color)) {
            return;
        }
        this._color = (Color)c;
        this.repaint();
        this.firePropertyChange();
    }

    public Object getValue() {
        return this._color;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle box) {
        g.draw3DRect(box.x, box.y, box.width - 1, box.height - 1, true);
        g.setColor((Color)this.getValue());
        g.fill3DRect(box.x + 1, box.y + 1, box.width - 2, box.height - 2, true);
    }

    public void paint(Graphics g) {
        this.paintValue(g, this.getBounds());
    }

    public String getJavaInitializationString() {
        Color c = (Color)this.getValue();
        return String.valueOf(String.valueOf(new StringBuffer("new Color(").append(this.getAsText()).append(")")));
    }

    public String getAsText() {
        return String.valueOf(String.valueOf(new StringBuffer("").append(this._color.getRed()).append(", ").append(this._color.getBlue()).append(", ").append(this._color.getGreen())));
    }

    public void setAsText(String text) {
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        ColorPickerGrid cpg = new ColorPickerGrid(Color.white);
        cpg.setPEColor(this);
        return cpg;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Dimension getMinimumSize() {
        return new Dimension(300, 400);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    public Frame getFrame() {
        Container c;
        for (c = this; c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        return (Frame)c;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener2) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener2);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener2) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener2);
    }

    public void firePropertyChange() {
        Vector targets;
        ColorEditor colorEditor = this;
        synchronized (colorEditor) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < targets.size(); ++i) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
            target.propertyChange(evt);
        }
    }
}

