/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import jclass.util.JCImage;
import jclass.util.JCStringTokenizer;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class JCString
extends JCVector {
    public static final Integer UNDERLINE = new Integer(-2);
    public static final Integer STRIKETHROUGH = new Integer(-3);
    public static final Integer END_UNDERLINE = new Integer(-4);
    public static final Integer END_STRIKETHROUGH = new Integer(-5);
    public static final Integer HORIZ_SPACE = new Integer(-6);
    public static final Integer VERT_SPACE = new Integer(-7);
    public static final Integer NEWLINE = new Integer(-8);
    public static final Integer RESET = new Integer(-9);
    public static final Integer DEFAULT_FONT = new Integer(-10);
    public static final Integer DEFAULT_COLOR = new Integer(-11);
    public static final Integer TOP = new Integer(-17);
    public static final Integer MIDDLE = new Integer(-18);
    public static final Integer BOTTOM = new Integer(-19);
    public static final Integer LEFT = new Integer(-17);
    public static final Integer CENTER = new Integer(-18);
    public static final Integer RIGHT = new Integer(-19);
    public static final Integer HREF = new Integer(-21);
    public static final Integer END_HREF = new Integer(-22);
    public static final int STRING_LEFT = 0;
    public static final int STRING_RIGHT = 1;
    public static final int STRING_TOP = 2;
    public static final int STRING_BOTTOM = 3;
    static final int NOTFOUND = -1;
    static final int DEFAULT_SPACE = 10;
    static boolean underline = false;
    static boolean strikethrough = false;
    static Dimension size = new Dimension();
    static Rectangle draw_rect = new Rectangle();
    private static Vector reg_images = new Vector();
    public static boolean is_img_caching = true;
    private static Hashtable img_cache = new Hashtable();
    Rectangle url_rect;
    String url;
    JCVector url_rect_list;
    JCVector url_list;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    int x_offset;
    int y_offset;
    static boolean has_url = false;

    public JCString() {
    }

    public JCString(int n) {
        super(n);
    }

    public JCString(String string) {
        super(1);
        this.addString(string);
    }

    public JCString(String string, Image image, int n) {
        this(5);
        if (string == null) {
            this.add(image);
            return;
        }
        if (image == null) {
            this.add(string);
            return;
        }
        switch (n) {
            case 0: {
                this.add(string);
                this.add(MIDDLE);
                this.add(HORIZ_SPACE);
                this.add(image);
                break;
            }
            case 2: {
                this.add(string);
                this.add(NEWLINE);
                this.add(VERT_SPACE);
                this.add(new Integer(5));
                this.add(image);
                break;
            }
            case 3: {
                this.add(image);
                this.add(NEWLINE);
                this.add(VERT_SPACE);
                this.add(new Integer(5));
                this.add(string);
                break;
            }
            default: {
                this.add(image);
                this.add(MIDDLE);
                this.add(HORIZ_SPACE);
                this.add(string);
            }
        }
    }

    public void add(int n) {
        this.addElement(new Integer(n));
    }

    public void add(int n, Object object) {
        this.add(n);
        this.add(object);
    }

    public boolean add(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            this.addString((String)object);
        } else {
            this.addElement(object);
        }
        return true;
    }

    public boolean addImage(Applet applet, String string) {
        return this.addImage(applet, applet.getDocumentBase(), string);
    }

    public boolean addImage(Applet applet, String string, String string2) {
        try {
            this.addImage(applet, new URL(string), string2);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean addImage(Applet applet, URL uRL, String string) {
        Image image = null;
        image = JCString.getCachedImage(String.valueOf(uRL.toString()) + string);
        if (image == null) {
            MediaTracker mediaTracker = new MediaTracker(applet);
            image = applet.getImage(uRL, string);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            JCString.putCachedImage(String.valueOf(uRL.toString()) + string, image);
        }
        this.add(image);
        return true;
    }

    private void addString(String string) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("\n", n)) != -1) {
            this.addElement(string.substring(n, n2));
            this.addElement(NEWLINE);
            n = n2 + 1;
        }
        this.addElement(string.substring(n));
    }

    public void draw(Component component, Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        int n3 = 0;
        int n4 = rectangle.y;
        this.url = null;
        this.url_rect_list = null;
        this.url_list = null;
        Font font = graphics.getFont();
        this.init();
        while ((n2 = this.getLineSize(component, font, n3, size)) != -1) {
            int n5 = this.getVertSpace(n3, n2);
            JCString.size.height -= n5;
            draw_rect.setBounds(rectangle.x, n4 += n5, JCString.size.width, JCString.size.height);
            if (n == 1) {
                JCString.draw_rect.x += (rectangle.width - JCString.size.width) / 2;
            } else if (n == 2) {
                JCString.draw_rect.x += rectangle.width - JCString.size.width;
            }
            this.drawLine(component, graphics, font, draw_rect, n3, n2);
            n3 = n2;
            n4 += JCString.size.height;
        }
    }

    void drawLine(Component component, Graphics graphics, Font font, Rectangle rectangle, int n, int n2) {
        Integer n3 = BOTTOM;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = n;
        while (n6 < n2 && n6 < this.size()) {
            if (this.elementData[n6] instanceof String) {
                int n7 = fontMetrics.getHeight();
                int n8 = n7 - fontMetrics.getAscent();
                if (n3.equals(BOTTOM)) {
                    n5 = rectangle.y + rectangle.height - n8;
                } else if (n3.equals(MIDDLE)) {
                    n5 = rectangle.y + (rectangle.height - n7) / 2 + n7 - n8;
                } else if (n3.equals(TOP)) {
                    n5 = rectangle.y + n7 - n8;
                }
                graphics.drawString((String)this.elementData[n6], n4, n5);
                if (this.url != null) {
                    this.startURL(n4, n5 - n7 + n8);
                }
                int n9 = JCString.stringWidth(fontMetrics, graphics.getFont(), (String)this.elementData[n6]);
                if (underline) {
                    graphics.drawLine(n4, n5 + 1, n4 + n9, n5 + 1);
                }
                if (strikethrough) {
                    graphics.drawLine(n4, n5 - n7 / 2 + 3, n4 + n9, n5 - n7 / 2 + 3);
                }
                n4 += n9;
                if (this.url != null) {
                    this.endURL(graphics, n4, n5 + n8);
                }
            } else if (this.elementData[n6] instanceof Image || this.elementData[n6] instanceof JCImage) {
                Image image;
                Object object = this.elementData[n6];
                Image image2 = image = object instanceof Image ? (Image)object : ((JCImage)object).image;
                if (this.url != null) {
                    this.startURL(n4, rectangle.y);
                }
                graphics.drawImage(image, n4, rectangle.y, null);
                n4 += image.getWidth(null);
                if (this.url != null) {
                    this.endURL(graphics, n4, rectangle.y + rectangle.height);
                }
            } else if (this.elementData[n6] instanceof Font) {
                graphics.setFont((Font)this.elementData[n6]);
                fontMetrics = graphics.getFontMetrics();
            } else if (this.elementData[n6].equals(DEFAULT_FONT)) {
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
            } else if (this.elementData[n6].equals(DEFAULT_COLOR)) {
                graphics.setColor(component.getForeground());
            } else if (this.elementData[n6].equals(HREF)) {
                underline = true;
                this.url = (String)this.elementData[++n6];
            } else if (this.elementData[n6].equals(UNDERLINE)) {
                underline = true;
            } else if (this.elementData[n6].equals(END_UNDERLINE)) {
                underline = false;
            } else if (this.elementData[n6].equals(END_HREF)) {
                underline = false;
                this.url = null;
            } else if (this.elementData[n6].equals(STRIKETHROUGH)) {
                strikethrough = true;
            } else if (this.elementData[n6].equals(END_STRIKETHROUGH)) {
                strikethrough = false;
            } else if (this.elementData[n6].equals(TOP)) {
                n3 = TOP;
            } else if (this.elementData[n6].equals(MIDDLE)) {
                n3 = MIDDLE;
            } else if (this.elementData[n6].equals(BOTTOM)) {
                n3 = BOTTOM;
            } else if (this.elementData[n6].equals(HORIZ_SPACE)) {
                n4 = n6 < this.size() - 1 && this.isValue(this.elementData[n6 + 1]) ? (n4 += ((Integer)this.elementData[++n6]).intValue()) : (n4 += 10);
            } else if (this.elementData[n6].equals(RESET)) {
                if (this.url == null) {
                    underline = false;
                }
                strikethrough = false;
                n3 = BOTTOM;
                graphics.setColor(component.getForeground());
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
            } else if (this.elementData[n6] instanceof Color) {
                graphics.setColor((Color)this.elementData[n6]);
            } else if (this.elementData[n6].equals(NEWLINE)) break;
            ++n6;
        }
    }

    private void endURL(Graphics graphics, int n, int n2) {
        this.url_list.addElement(this.url);
        this.url_rect.width = n - this.url_rect.x;
        this.url_rect.height = n2 - this.url_rect.y;
        this.url_rect.translate(this.x_offset, this.y_offset);
        this.url_rect_list.addElement(this.url_rect);
    }

    public static Applet getApplet(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        Container container2 = component.getParent();
        while (container2 != null && !(container2 instanceof Applet)) {
            container2 = container;
            container = container == null ? null : container.getParent();
        }
        return (Applet)container2;
    }

    private static Image getCachedImage(String string) {
        if (!is_img_caching) {
            return null;
        }
        return (Image)img_cache.get(string);
    }

    public int getHeight(Component component, Font font) {
        return this.getSize((Component)component, (Font)font).height;
    }

    public Image getImage() {
        int n = 0;
        while (n < this.size()) {
            if (this.elementData[n] instanceof Image) {
                return (Image)this.elementData[n];
            }
            if (this.elementData[n] instanceof JCImage) {
                return ((JCImage)this.elementData[n]).image;
            }
            ++n;
        }
        return null;
    }

    public static boolean getIsImageCaching() {
        return is_img_caching;
    }

    public int getLineSize(Component component, Font font, int n, Dimension dimension) {
        if (n >= this.size()) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Graphics graphics = component.getGraphics();
        if (graphics == null) {
            return -1;
        }
        int n7 = n;
        while (n7 >= 0) {
            if (this.elementData[n7] instanceof Font) {
                graphics.setFont((Font)this.elementData[n7]);
                break;
            }
            if (this.elementData[n7].equals(DEFAULT_FONT)) {
                graphics.setFont(font);
                break;
            }
            --n7;
        }
        if (n7 < 0 && font != null) {
            graphics.setFont(font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n7 = n;
        while (n7 < this.size()) {
            Image image;
            if (this.elementData[n7] instanceof String) {
                n6 = Math.max(n6, fontMetrics.getHeight());
                n5 += JCString.stringWidth(fontMetrics, graphics.getFont(), (String)this.elementData[n7]);
            } else if (this.elementData[n7] instanceof Font) {
                graphics.setFont((Font)this.elementData[n7]);
                fontMetrics = graphics.getFontMetrics();
            } else if (this.elementData[n7] instanceof Image) {
                image = (Image)this.elementData[n7];
                n6 = Math.max(n6, image.getHeight(null));
                n5 += image.getWidth(null);
            } else if (this.elementData[n7] instanceof JCImage) {
                image = ((JCImage)this.elementData[n7]).image;
                n6 = Math.max(n6, image.getHeight(null));
                n5 += image.getWidth(null);
            } else if (this.elementData[n7].equals(HREF)) {
                ++n7;
            } else if (this.elementData[n7].equals(DEFAULT_FONT)) {
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
            } else if (this.elementData[n7].equals(HORIZ_SPACE)) {
                n5 = n7 < this.size() - 1 && this.isValue(this.elementData[n7 + 1]) ? (n5 += ((Integer)this.elementData[++n7]).intValue()) : (n5 += 10);
            } else if (this.elementData[n7].equals(VERT_SPACE)) {
                n2 = n7 < this.size() - 1 && this.isValue(this.elementData[n7 + 1]) ? (Integer)this.elementData[++n7] : 10;
            } else if (this.elementData[n7].equals(NEWLINE)) {
                n3 += n6;
                n4 = Math.max(n4, n5);
                n5 = 0;
                n6 = 0;
                break;
            }
            ++n7;
        }
        dimension.width = Math.max(n4, n5);
        dimension.height = n3 + n6 + n2;
        return n7 + 1;
    }

    public Dimension getSize(Component component, Font font) {
        Dimension dimension = new Dimension();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (font == null) {
            font = component.getFont();
        }
        this.init();
        while ((n = this.getLineSize(component, font, n, dimension)) != -1) {
            n2 = Math.max(n2, dimension.width);
            n3 += dimension.height;
        }
        dimension.width = n2;
        dimension.height = n3;
        return dimension;
    }

    public String getString() {
        String string = new String();
        int n = 0;
        while (n < this.size()) {
            if (this.elementData[n].equals(HREF)) {
                ++n;
            } else if (this.elementData[n] instanceof String) {
                string = string.concat((String)this.elementData[n]);
            } else if (this.elementData[n].equals(NEWLINE)) {
                string = string.concat("\n");
            }
            ++n;
        }
        return string;
    }

    public String getURL(int n, int n2) {
        if (this.url_rect_list != null) {
            int n3 = 0;
            while (n3 < this.url_rect_list.size()) {
                if (((Rectangle)this.url_rect_list.elementAt(n3)).contains(n, n2)) {
                    return (String)this.url_list.elementAt(n3);
                }
                ++n3;
            }
        }
        return null;
    }

    public static String getURL(Applet applet, Object object, int n, int n2) {
        String string = null;
        if (applet != null) {
            try {
                if (applet.getAppletContext() == null) {
                    applet = null;
                }
            }
            catch (Exception exception) {
                applet = null;
            }
        }
        if (object instanceof JCString) {
            string = ((JCString)object).getURL(n, n2);
            if (string != null && applet != null) {
                int n3 = Math.max(string.indexOf("TARGET="), string.indexOf("target="));
                if (n3 == -1) {
                    applet.showStatus(string);
                } else {
                    applet.showStatus(string.substring(0, n3));
                }
            }
            has_url = true;
        }
        if (applet != null && has_url && string == null) {
            applet.showStatus(null);
        }
        if (string == null) {
            has_url = false;
        }
        return string;
    }

    int getVertSpace(int n, int n2) {
        int n3 = n;
        while (n3 < n2 && n3 < this.size()) {
            if (this.elementData[n3].equals(VERT_SPACE)) {
                if (n3 < this.size() - 1 && this.isValue(this.elementData[n3 + 1])) {
                    return (Integer)this.elementData[++n3];
                }
                return 10;
            }
            ++n3;
        }
        return 0;
    }

    public int getWidth(Component component, Font font) {
        return this.getSize((Component)component, (Font)font).width;
    }

    private void init() {
        strikethrough = false;
        underline = false;
    }

    private boolean isValue(Object object) {
        return object instanceof Integer && (Integer)object >= 0;
    }

    public static JCString parse(Component component, String string) {
        if (string == null) {
            return null;
        }
        JCString jCString = new JCString();
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken('[');
            jCString.add(string2);
            if (!jCStringTokenizer.hasMoreTokens()) continue;
            string2 = jCStringTokenizer.nextToken(']');
            if (string2 != null) {
                string2.trim();
            }
            JCString.parseToken(component, jCString, string2);
        }
        return jCString;
    }

    private static void parseToken(Component component, JCString jCString, String string) {
        if (string == null) {
            return;
        }
        String string2 = null;
        String string3 = string;
        int n = string.indexOf(61);
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        if (string3.equalsIgnoreCase("DEFAULT_FONT")) {
            jCString.add(DEFAULT_FONT);
        } else if (string3.equalsIgnoreCase("DEFAULT_COLOR")) {
            jCString.add(DEFAULT_COLOR);
        } else if (string3.equalsIgnoreCase("UNDERLINE") || string3.equalsIgnoreCase("UL")) {
            jCString.add(UNDERLINE);
        } else if (string3.equalsIgnoreCase("/UNDERLINE") || string3.equalsIgnoreCase("/UL")) {
            jCString.add(END_UNDERLINE);
        } else if (string3.equalsIgnoreCase("STRIKETHROUGH") || string3.equalsIgnoreCase("ST")) {
            jCString.add(STRIKETHROUGH);
        } else if (string3.equalsIgnoreCase("/STRIKETHROUGH") || string3.equalsIgnoreCase("/ST")) {
            jCString.add(END_STRIKETHROUGH);
        } else if (string3.equalsIgnoreCase("HREF")) {
            jCString.add(HREF);
            jCString.add(string2);
        } else if (string3.equalsIgnoreCase("/HREF")) {
            jCString.add(END_HREF);
        } else if (string3.equalsIgnoreCase("ALIGN")) {
            if (string2.equalsIgnoreCase("TOP")) {
                jCString.add(TOP);
            } else if (string2.equalsIgnoreCase("MIDDLE")) {
                jCString.add(MIDDLE);
            } else if (string2.equalsIgnoreCase("BOTTOM")) {
                jCString.add(BOTTOM);
            }
        } else if (string3.equalsIgnoreCase("HORIZ_SPACE")) {
            jCString.add(HORIZ_SPACE);
            if (string2 != null) {
                jCString.add(Integer.valueOf(string2));
            }
        } else if (string3.equalsIgnoreCase("VERT_SPACE")) {
            jCString.add(VERT_SPACE);
            if (string2 != null) {
                jCString.add(Integer.valueOf(string2));
            }
        } else if (string3.equalsIgnoreCase("RESET")) {
            jCString.add(RESET);
        } else if (string3.equalsIgnoreCase("COLOR")) {
            if (string2 != null) {
                if (string2.equalsIgnoreCase("DEFAULT")) {
                    jCString.add(DEFAULT_COLOR);
                } else {
                    jCString.add(JCUtilConverter.toColor(string2));
                }
            }
        } else if (string3.equalsIgnoreCase("IMAGE") || string3.equalsIgnoreCase("IMG")) {
            int n2 = -1;
            Image image = null;
            if (string2 != null) {
                block51: {
                    try {
                        n2 = Integer.valueOf(string2);
                        if (n2 > 0 && n2 <= reg_images.size()) {
                            image = (Image)reg_images.elementAt(n2 - 1);
                        }
                    }
                    catch (Exception exception) {
                        String string4;
                        if (component == null || (image = JCString.getCachedImage(string4 = String.valueOf(String.valueOf(JCString.getApplet(component))) + string2)) != null || (image = JCUtilConverter.toImage(component, string2)) == null) break block51;
                        JCString.putCachedImage(string4, image);
                    }
                }
                if (image != null) {
                    jCString.add(new JCImage(image, string2));
                }
            }
        } else if (string3.equalsIgnoreCase("FONT")) {
            if (string2 != null) {
                if (string2.equalsIgnoreCase("DEFAULT")) {
                    jCString.add(DEFAULT_FONT);
                } else {
                    jCString.add(JCUtilConverter.toFont(string2));
                }
            }
        } else if (string3.equalsIgnoreCase("NEWLINE")) {
            jCString.add(NEWLINE);
        }
    }

    private static void putCachedImage(String string, Image image) {
        if (!is_img_caching && image != null) {
            return;
        }
        img_cache.put(string, image);
    }

    public static int registerImage(Image image) {
        reg_images.addElement(image);
        return reg_images.size();
    }

    public static void setIsImageCaching(boolean bl) {
        is_img_caching = bl;
    }

    public void setURLoffset(int n, int n2) {
        this.x_offset = n;
        this.y_offset = n2;
    }

    public static boolean showURL(String string, AppletContext appletContext, Applet applet) {
        if (string == null || appletContext == null) {
            return false;
        }
        int n = string.indexOf("TARGET=");
        String string2 = n == -1 ? string : string.substring(0, n);
        String string3 = n == -1 ? null : string.substring(n + 7);
        try {
            URL uRL = new URL(applet.getDocumentBase(), string2);
            if (string3 == null) {
                appletContext.showDocument(uRL);
            } else {
                appletContext.showDocument(uRL, string3);
            }
        }
        catch (Exception exception) {
            applet.showStatus("Invalid URL");
            return false;
        }
        return true;
    }

    private void startURL(int n, int n2) {
        this.url_rect = new Rectangle();
        this.url_rect.x = n;
        this.url_rect.y = n2;
        if (this.url_list == null) {
            this.url_list = new JCVector();
        }
        if (this.url_rect_list == null) {
            this.url_rect_list = new JCVector();
        }
    }

    static int stringWidth(FontMetrics fontMetrics, Font font, String string) {
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    public String toString2() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            Object e = this.elementAt(n);
            String string = "";
            if (e instanceof String) {
                string = e.toString();
            } else if (e == DEFAULT_FONT) {
                string = "[DEFAULT_FONT]";
            } else if (e == DEFAULT_COLOR) {
                string = "[DEFAULT_COLOR]";
            } else if (e == UNDERLINE) {
                string = "[UL]";
            } else if (e == END_UNDERLINE) {
                string = "[/UL]";
            } else if (e == STRIKETHROUGH) {
                string = "[ST]";
            } else if (e == END_STRIKETHROUGH) {
                string = "[/ST]";
            } else if (e == HREF) {
                string = "[HREF=" + this.elementAt(++n) + "]";
            } else if (e == END_HREF) {
                string = "[/HREF]";
            } else if (e == TOP) {
                string = "[ALIGN=TOP]";
            } else if (e == MIDDLE) {
                string = "[ALIGN=MIDDLE]";
            } else if (e == BOTTOM) {
                string = "[ALIGN=BOTTOM]";
            } else if (e == HORIZ_SPACE) {
                string = "[HORIZ_SPACE";
                if (n < this.size() - 1 && this.isValue(this.elementData[n + 1])) {
                    string = String.valueOf(string) + "=" + this.elementData[++n];
                }
                string = String.valueOf(string) + "]";
            } else if (e == VERT_SPACE) {
                string = "[VERT_SPACE";
                if (n < this.size() - 1 && this.isValue(this.elementData[n + 1])) {
                    string = String.valueOf(string) + "=" + this.elementData[++n];
                }
                string = String.valueOf(string) + "]";
            } else if (e == RESET) {
                string = "[RESET]";
            } else if (e == DEFAULT_COLOR) {
                string = "[COLOR=DEFAULT]";
            } else if (e instanceof Color) {
                string = "[COLOR=" + JCUtilConverter.fromColor((Color)e) + "]";
            } else if (e instanceof Image) {
                string = "";
            } else if (e instanceof JCImage) {
                string = "[IMG=" + ((JCImage)e).file + "]";
            } else if (e == DEFAULT_FONT) {
                string = "[FONT=DEFAULT]";
            } else if (e instanceof Font) {
                string = "[FONT=" + JCUtilConverter.fromFont((Font)e) + "]";
            } else if (e == NEWLINE) {
                string = "[NEWLINE]";
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }
}

