/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import jclass.beans.GroupPanel;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SBLayoutWrapper;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.SBLayoutCellRenderer;

public class SBLayoutEditor
extends SeriesEditor
implements ActionListener,
FocusListener {
    private TextField textHoriz;
    private TextField textVert;

    public SBLayoutEditor() {
        super(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.textHoriz) || object.equals(this.textVert)) {
            this.setOffset();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        Object object = focusEvent.getSource();
        if (object.equals(this.textHoriz) || object.equals(this.textVert)) {
            this.setOffset();
        }
    }

    private int getInt(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public String getJavaInitializationString() {
        return "new jclass.table3.SBLayoutWrapper(" + this.getAsText() + ")";
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new SBLayoutCellRenderer(this);
    }

    public Object getValue() {
        return this.tableView.getSBLayout();
    }

    protected void init() {
        super.init();
        this.tableView.setSelectionPolicy(0);
        this.tableView.setHorizSBDisplay(1);
        this.tableView.setVertSBDisplay(1);
    }

    protected Component makePropertyPanel() {
        this.textHoriz = new TextField("0", 2);
        this.textVert = new TextField("0", 2);
        GroupPanel groupPanel = new GroupPanel("Scrollbar Offset Layout");
        groupPanel.setLayout(new FlowLayout(0, 10, 6));
        groupPanel.add(new Label("Horizontal scrollbar"));
        groupPanel.add(this.textHoriz);
        groupPanel.add(new Label("Vertical scrollbar"));
        groupPanel.add(this.textVert);
        this.textHoriz.addActionListener(this);
        this.textVert.addActionListener(this);
        this.textHoriz.addFocusListener(this);
        this.textVert.addFocusListener(this);
        return groupPanel;
    }

    private void setOffset() {
        this.tableView.setHorizSBOffset(this.getInt(this.textHoriz.getText()));
        this.tableView.setVertSBOffset(this.getInt(this.textVert.getText()));
        this.support.firePropertyChange("sbLayout", null, this.getValue());
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new SBLayoutWrapper(0, 0);
        }
        this.tableView.setSBLayout((SBLayoutWrapper)object);
        this.updatePropertyPanel();
        super.setValue(object);
    }

    protected void updatePropertyPanel() {
        this.updateTextField(this.textVert, this.tableView.getVertSBOffset());
        this.updateTextField(this.textHoriz, this.tableView.getHorizSBOffset());
    }

    protected void updateTextField(TextField textField, int n) {
        String string = String.valueOf(n);
        if (!string.equalsIgnoreCase(textField.getText())) {
            textField.setText(string);
        }
    }
}

