/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jclass.beans.GroupPanel;
import jclass.table3.FrozenCellLayoutWrapper;
import jclass.table3.LiveTable;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.FrozenCellLayoutCellRenderer;

public class FrozenCellLayoutEditor
extends SeriesEditor
implements ActionListener,
ItemListener {
    private Choice choiceColumn;
    private Choice choiceRow;

    public FrozenCellLayoutEditor() {
        super(0);
    }

    public FrozenCellLayoutEditor(int n) {
        super(n);
    }

    public String getJavaInitializationString() {
        return "new jclass.table3.FrozenCellLayoutWrapper(" + this.getAsText() + ")";
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new FrozenCellLayoutCellRenderer(this);
    }

    public Object getValue() {
        return this.tableView.getFrozenCellLayout();
    }

    protected void init() {
        super.init();
        this.tableView.setSelectionPolicy(0);
        this.tableView.setFrozenColumns(1);
        if (this.selectionPolicy != 4) {
            this.tableView.setFrozenRows(1);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceColumn)) {
            string = this.choiceColumn.getSelectedItem();
            this.tableView.setFrozenColumnPlacement(string.equals("left") ? 0 : 2);
            this.support.firePropertyChange("frozenCellLayout", null, this.getValue());
        }
        if (this.selectionPolicy != 4 && object.equals(this.choiceRow)) {
            string = this.choiceRow.getSelectedItem();
            this.tableView.setFrozenRowPlacement(string.equals("top") ? 0 : 6);
            this.support.firePropertyChange("frozenCellLayout", null, this.getValue());
        }
    }

    protected Component makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel("Frozen Cell Layout");
        groupPanel.setLayout(new FlowLayout(0, 10, 6));
        this.choiceColumn = new Choice();
        this.choiceColumn.addItem("left");
        this.choiceColumn.addItem("right");
        groupPanel.add(new Label("Column placement"));
        groupPanel.add(this.choiceColumn);
        this.choiceColumn.addItemListener(this);
        if (this.selectionPolicy != 4) {
            this.choiceRow = new Choice();
            this.choiceRow.addItem("top");
            this.choiceRow.addItem("bottom");
            groupPanel.add(new Label("Row placement"));
            groupPanel.add(this.choiceRow);
            this.choiceRow.addItemListener(this);
        } else {
            this.choiceRow = null;
        }
        return groupPanel;
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new FrozenCellLayoutWrapper(0, 0);
        }
        this.tableView.setFrozenCellLayout((FrozenCellLayoutWrapper)object);
        this.updatePropertyPanel();
        super.setValue(object);
    }

    protected void updatePropertyPanel() {
        this.choiceColumn.select(this.tableView.getFrozenColumnPlacement() == 0 ? "left" : "right");
        if (this.selectionPolicy != 4) {
            this.choiceRow.select(this.tableView.getFrozenRowPlacement() == 0 ? "top" : "bottom");
        }
    }

    protected boolean updateTableSize() {
        boolean bl = super.updateTableSize();
        if (bl) {
            int n = LiveTable.getNumEditorColumns();
            this.tableView.setFrozenColumns(n > 1 ? 1 : 0);
            if (this.selectionPolicy != 4) {
                int n2 = LiveTable.getNumEditorRows();
                this.tableView.setFrozenRows(n2 > 1 ? 1 : 0);
            }
        }
        return bl;
    }
}

