/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jclass.beans.GroupPanel;
import jclass.table3.CellSizeWrapper;
import jclass.table3.JCCellRange;
import jclass.table3.JCResizeCellEvent;
import jclass.table3.JCResizeCellListener;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.CellSizeCellRenderer;

public class CellSizeEditor
extends SeriesEditor
implements ActionListener,
FocusListener,
ItemListener,
JCResizeCellListener {
    private TextField textWidth;
    private TextField textHeight;
    private Choice choiceWidth;
    private Choice choiceHeight;
    protected static final String AS_IS = "Fixed";
    protected static final String VARIABLE = "Variable";

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.textWidth) || object.equals(this.textHeight)) {
            this.setSize();
        }
    }

    private void enable(TextField textField, boolean bl, int n) {
        textField.setEnabled(bl);
        textField.setText(bl ? String.valueOf(n) : "");
    }

    private void enableText() {
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange != null) {
            this.enable(this.textWidth, this.choiceWidth.getSelectedItem().compareTo(AS_IS) == 0, this.tableView.getColumnPixelWidth(this.getFirstCell(jCCellRange.start_column)));
            this.enable(this.textHeight, this.choiceHeight.getSelectedItem().compareTo(AS_IS) == 0, this.tableView.getRowPixelHeight(this.getFirstCell(jCCellRange.start_row)));
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        Object object = focusEvent.getSource();
        if (object.equals(this.textWidth) || object.equals(this.textHeight)) {
            this.setSize();
        }
    }

    private int getFirstCell(int n) {
        return n == -998 ? -1 : (n == -997 ? 0 : n);
    }

    private int getInt(TextField textField) {
        try {
            int n = new Integer(textField.getText());
            if (n < 0) {
                n = 0;
            }
            if (n > 1024) {
                n = 1024;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getJavaInitializationString() {
        String string = this.getStringValue(",\n      ");
        return "new jclass.table3.CellSizeWrapper(" + string + ")";
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new CellSizeCellRenderer(this);
    }

    private String getStringValue(String string) {
        return "\"" + this.tableView.fromSeries(14) + "\"" + string + "\"" + this.tableView.fromSeries(13) + "\"";
    }

    public Object getValue() {
        return this.tableView.getCellSize();
    }

    protected void init() {
        super.init();
        this.tableView.setAllowCellResize(1);
        this.tableView.addResizeCellListener(this);
        this.enableText();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceWidth) || object.equals(this.choiceHeight)) {
            this.enableText();
            this.setSize();
        }
    }

    protected Component makePropertyPanel() {
        this.choiceWidth = new Choice();
        this.choiceHeight = new Choice();
        this.textWidth = new TextField(3);
        this.textHeight = new TextField(3);
        this.choiceWidth.add(VARIABLE);
        this.choiceWidth.add(AS_IS);
        this.choiceHeight.add(VARIABLE);
        this.choiceHeight.add(AS_IS);
        GroupPanel groupPanel = new GroupPanel("Cell size");
        groupPanel.setLayout(new FlowLayout(0, 10, 6));
        groupPanel.add(new Label("Width"));
        groupPanel.add(this.choiceWidth);
        groupPanel.add(this.textWidth);
        groupPanel.add(new Label("pixels  "));
        groupPanel.add(new Label("Height"));
        groupPanel.add(this.choiceHeight);
        groupPanel.add(this.textHeight);
        groupPanel.add(new Label("pixels  "));
        this.textWidth.addActionListener(this);
        this.textHeight.addActionListener(this);
        this.textWidth.addFocusListener(this);
        this.textHeight.addFocusListener(this);
        this.choiceWidth.addItemListener(this);
        this.choiceHeight.addItemListener(this);
        return groupPanel;
    }

    public void resizeCellBegin(JCResizeCellEvent jCResizeCellEvent) {
    }

    public void resizeCellEnd(JCResizeCellEvent jCResizeCellEvent) {
        boolean bl;
        JCCellRange jCCellRange = new JCCellRange();
        int n = jCResizeCellEvent.getRow();
        int n2 = jCResizeCellEvent.getColumn();
        int n3 = jCResizeCellEvent.getNewRowHeight();
        int n4 = jCResizeCellEvent.getNewColumnWidth();
        jCResizeCellEvent.setAllowResize(false);
        if (n3 != -999) {
            this.textHeight.setText(String.valueOf(n3));
            this.tableView.setPixelHeight(n, n3);
            bl = n3 == 33001;
            this.choiceHeight.select(bl ? VARIABLE : AS_IS);
            this.enable(this.textHeight, bl ^ true, n3);
        }
        if (n4 != -999) {
            this.textWidth.setText(String.valueOf(n4));
            this.tableView.setPixelWidth(n2, n4);
            bl = n4 == 33001;
            this.choiceWidth.select(bl ? VARIABLE : AS_IS);
            this.enable(this.textWidth, bl ^ true, n4);
        }
        this.updatePropertyPanel(null);
    }

    private void setSize() {
        int n;
        int n2;
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        int n3 = n2 = this.choiceHeight.getSelectedItem().compareTo(VARIABLE) == 0 ? 33001 : this.getInt(this.textHeight);
        if (n2 != 0) {
            if (jCCellRange.start_row == -998 || jCCellRange.start_row == -997) {
                this.tableView.setPixelHeight(jCCellRange.start_row, n2);
            } else {
                n = jCCellRange.start_row;
                while (n <= jCCellRange.end_row) {
                    this.tableView.setPixelHeight(n, n2);
                    ++n;
                }
            }
        } else {
            this.errorMessageBox("Invalid row height.");
        }
        int n4 = n = this.choiceWidth.getSelectedItem().compareTo(VARIABLE) == 0 ? 33001 : this.getInt(this.textWidth);
        if (n != 0) {
            if (jCCellRange.start_column == -998 || jCCellRange.start_column == -997) {
                this.tableView.setPixelWidth(jCCellRange.start_column, n);
            } else {
                int n5 = jCCellRange.start_column;
                while (n5 <= jCCellRange.end_column) {
                    this.tableView.setPixelWidth(n5, n);
                    ++n5;
                }
            }
        } else {
            this.errorMessageBox("Invalid column width.");
        }
        this.enable(this.textWidth, n != 33001, this.tableView.getColumnPixelWidth(this.getFirstCell(jCCellRange.start_column)));
        this.enable(this.textHeight, n2 != 33001, this.tableView.getRowPixelHeight(this.getFirstCell(jCCellRange.start_row)));
        this.updatePropertyPanel(null);
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new CellSizeWrapper("(all VARIABLE)", "(all 22)");
        }
        this.tableView.setCellSize((CellSizeWrapper)object);
        super.setValue(object);
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        if (jCCellRange != null) {
            this.updateSize(jCCellRange);
        }
        this.support.firePropertyChange("cellSize", null, this.getValue());
    }

    private void updateSize(JCCellRange jCCellRange) {
        int n = this.tableView.getPixelWidth(jCCellRange.start_column);
        this.choiceWidth.select(n == 33001 ? VARIABLE : AS_IS);
        this.enable(this.textWidth, n != 33001, this.tableView.getColumnPixelWidth(this.getFirstCell(jCCellRange.start_column)));
        int n2 = this.tableView.getPixelHeight(jCCellRange.start_row);
        this.choiceHeight.select(n2 == 33001 ? VARIABLE : AS_IS);
        this.enable(this.textHeight, n2 != 33001, this.tableView.getRowPixelHeight(this.getFirstCell(jCCellRange.start_row)));
    }
}

