/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import jclass.table3.InputHandler;
import jclass.table3.JCCellPosition;
import jclass.table3.JCTraverseCellEvent;
import jclass.table3.Table;

class TraverseHandler
implements Serializable,
FocusListener,
KeyListener {
    Table table;
    boolean forward = true;

    public TraverseHandler(Table table) {
        this.table = table;
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        JCCellPosition jCCellPosition = this.table.getPosition(component, null);
        this.table.editHandler.commit(true);
        if (!component.isFocusTraversable()) {
            component.addKeyListener(this);
        }
        if (jCCellPosition == null) {
            return;
        }
        this.table.edit_row = jCCellPosition.row;
        this.table.edit_column = jCCellPosition.column;
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        JCCellPosition jCCellPosition = this.table.getPosition(component, null);
        component.removeKeyListener(this);
        if (jCCellPosition != null && (this.table.edit_row != jCCellPosition.row || this.table.edit_column != jCCellPosition.column) && (component = this.table.getComponent(this.table.edit_row, this.table.edit_column)) != null) {
            this.table.edit_row = jCCellPosition.row;
            this.table.edit_column = jCCellPosition.column;
            component.requestFocus();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.forward = !keyEvent.isShiftDown();
            this.traverseNext(this.table.getPosition(keyEvent.getComponent(), null));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void traverseNext(JCCellPosition jCCellPosition) {
        Serializable serializable;
        JCCellPosition jCCellPosition2 = null;
        String string = "POINTER";
        if (this.forward) {
            string = "RIGHT";
            jCCellPosition2 = InputHandler.findTraversableCell(this.table, string, jCCellPosition.row, jCCellPosition.column);
        } else {
            string = "LEFT";
            jCCellPosition2 = InputHandler.findTraversableCell(this.table, string, jCCellPosition.row, jCCellPosition.column);
        }
        int n = jCCellPosition2.row;
        int n2 = jCCellPosition2.column;
        if (this.table.traverseCellListeners != null) {
            serializable = new JCTraverseCellEvent(this.table, jCCellPosition.row, jCCellPosition.column, jCCellPosition2.row, jCCellPosition2.column, string);
            this.table.fireJCTraverseCellEvent((JCTraverseCellEvent)serializable);
            n = ((JCTraverseCellEvent)serializable).next_row;
            n2 = ((JCTraverseCellEvent)serializable).next_column;
        }
        this.table.editHandler.traverse(n, n2, false, null, string, false);
        serializable = this.table.getComponent(this.table.edit_row, this.table.edit_column);
        if (serializable != null) {
            ((Component)serializable).requestFocus();
        }
    }
}

