/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.event.KeyEvent;
import jclass.cell.BaseInitialEvent;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.editors.StringCellEditor;
import jclass.table3.TableCellInfo;
import jclass.util.JCEnvironment;

public class TextCellEditor
extends StringCellEditor {
    protected TableCellInfo info;

    public char convertKey(char c) {
        int n = this.info.getStringCase();
        if (n == 2) {
            return Character.toUpperCase(c);
        }
        if (n == 1) {
            return Character.toLowerCase(c);
        }
        return c;
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.info = (TableCellInfo)cellInfo;
        if (initialEvent.getEventType() == 2 && initialEvent instanceof BaseInitialEvent) {
            BaseInitialEvent baseInitialEvent = (BaseInitialEvent)initialEvent;
            baseInitialEvent.setKey(this.convertKey((char)baseInitialEvent.getKey()));
        }
        super.initialize(initialEvent, cellInfo, object);
        if (JCEnvironment.getVendorString().startsWith("Microsoft")) {
            if ((char)initialEvent.getKey() >= ' ' && (char)initialEvent.getKey() <= '~') {
                this.setText(String.valueOf(this.getText()) + String.valueOf((char)initialEvent.getKey()));
            } else {
                this.setText(this.getText());
            }
            ++this.caretPosition;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2;
        super.keyPressed(keyEvent);
        if (JCEnvironment.getOS() != 1 || JCEnvironment.getJavaVersion() < 110) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c >= ' ' && c <= '~' && (n2 = this.info.getMaxLength()) < Integer.MAX_VALUE && (n = this.getText().length()) >= n2) {
            keyEvent.consume();
        }
        if ((n2 = this.info.getStringCase()) == 2) {
            keyEvent.setKeyChar(Character.toUpperCase(keyEvent.getKeyChar()));
        } else if (n2 == 1) {
            keyEvent.setModifiers(0);
            keyEvent.setKeyChar(Character.toLowerCase(keyEvent.getKeyChar()));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n;
        int n2;
        char c = keyEvent.getKeyChar();
        if (c >= ' ' && c <= '~' && (n2 = this.info.getMaxLength()) < Integer.MAX_VALUE && (n = this.getText().length()) >= n2) {
            keyEvent.consume();
        }
        if ((n2 = this.info.getStringCase()) == 2) {
            keyEvent.setModifiers(1);
            keyEvent.setKeyChar(Character.toUpperCase(keyEvent.getKeyChar()));
        } else if (n2 == 1) {
            keyEvent.setModifiers(0);
            keyEvent.setKeyChar(Character.toLowerCase(keyEvent.getKeyChar()));
        }
    }
}

