/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.io.Serializable;
import jclass.table3.AdjustmentEventQueue;
import jclass.table3.Clip;
import jclass.table3.DefaultScrollbar;
import jclass.table3.JCAdjustable;
import jclass.table3.JCAdjustmentEvent;
import jclass.table3.JCAdjustmentListener;
import jclass.table3.JCCellRange;
import jclass.table3.JCScrollEvent;
import jclass.table3.JDKSupport;
import jclass.table3.Jump;
import jclass.table3.Table;
import jclass.table3.Widget;

public class TableScrollbar
implements JCAdjustmentListener,
Serializable,
Runnable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    JCAdjustable adjustable;
    Component component;
    Table table;
    Rectangle saveRect = new Rectangle();
    JCCellRange saveRange = new JCCellRange();
    AdjustmentEventQueue queue = new AdjustmentEventQueue();
    Thread queueThread;

    public TableScrollbar(Table table, int n) {
        this.table = table;
        DefaultScrollbar defaultScrollbar = new DefaultScrollbar(n);
        this.adjustable = defaultScrollbar;
        this.component = defaultScrollbar;
        this.adjustable.addAdjustmentListener(this);
    }

    public boolean adjustValue() {
        JCAdjustmentEvent jCAdjustmentEvent = this.queue.getEvent();
        return this.adjustValue(jCAdjustmentEvent);
    }

    public boolean adjustValue(JCAdjustmentEvent jCAdjustmentEvent) {
        if (jCAdjustmentEvent != null) {
            int n = jCAdjustmentEvent.getValue();
            int n2 = this.adjustable.getOrientation();
            JCScrollEvent jCScrollEvent = new JCScrollEvent(this.table, 1, this, n2, n, jCAdjustmentEvent);
            this.table.fireJCScrollEvent(jCScrollEvent);
            n = jCScrollEvent.getValue();
            if (n2 == 0) {
                int n3;
                if ((this.table.jump & 1) != 0 && this.table.isJumping) {
                    n3 = n;
                    if ((n = Jump.scroll(this, jCAdjustmentEvent, n)) == -999) {
                        return true;
                    }
                    if (jCAdjustmentEvent.getAdjustmentType() == 5 && Math.abs(n3 - n) > 10) {
                        return true;
                    }
                }
                this.adjustable.setValue(n);
                n3 = this.table.XtoColumn(n + this.table.clip.xOffset());
                if (this.table.repaint) {
                    this.table.scrolling = true;
                    int n4 = 0;
                    while (n4 < this.table.clip_list.length) {
                        Clip clip = this.table.clip_list[n4];
                        if (clip.isHorizontal()) {
                            this.scroll_horiz(clip, n, this.saveRect);
                        }
                        ++n4;
                    }
                    if (this.table.hasText()) {
                        this.table.editHandler.move(0, n);
                    }
                    this.table.scrolling = false;
                }
                this.table.left_column = n3;
                if (this.table.component_series.size() > 0) {
                    Widget.scroll(this.table, 1);
                }
            } else if (n2 == 1) {
                if ((this.table.jump & 2) != 0 && this.table.isJumping && (n = Jump.scroll(this, jCAdjustmentEvent, n)) == -999) {
                    return true;
                }
                this.adjustable.setValue(n);
                int n5 = this.table.YtoRow(n + this.table.clip.yOffset());
                if (this.table.repaint) {
                    this.table.scrolling = true;
                    int n6 = 0;
                    while (n6 < this.table.clip_list.length) {
                        Clip clip = this.table.clip_list[n6];
                        if (clip.isVertical()) {
                            this.scroll_vert(clip, n, this.saveRect);
                        }
                        ++n6;
                    }
                    if (this.table.hasText()) {
                        this.table.editHandler.move(0, n);
                    }
                    this.table.scrolling = false;
                }
                this.table.top_row = n5;
                if (this.table.component_series.size() > 0) {
                    Widget.scroll(this.table, 2);
                }
            }
            jCScrollEvent = new JCScrollEvent(this.table, 2, this, n2, n, jCAdjustmentEvent);
            this.table.fireJCScrollEvent(jCScrollEvent);
            return true;
        }
        return false;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        JCAdjustmentEvent jCAdjustmentEvent = new JCAdjustmentEvent(adjustmentEvent);
        if (this.adjustable == null || this.component == null) {
            System.out.println("Scrollbar in an odd state");
            return;
        }
        this.queue.setEvent(jCAdjustmentEvent);
        if (this.queueThread == null) {
            this.queueThread = new Thread((Runnable)this, "ScrollThread");
            this.queueThread.start();
        }
    }

    public boolean atEnd() {
        int n = this.adjustable.getValue();
        int n2 = this.adjustable.getMaximum();
        int n3 = this.adjustable.getVisibleAmount();
        return n == 0 || n >= n2 - n3;
    }

    void dispose() {
        if (this.component != null) {
            if (this.component instanceof DefaultScrollbar) {
                ((DefaultScrollbar)this.component).dispose();
            }
            this.component = null;
        }
    }

    public JCAdjustable getAdjustable() {
        return this.adjustable;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getOrientation() {
        return this.adjustable.getOrientation();
    }

    public int getUnitIncrement() {
        return this.adjustable.getUnitIncrement();
    }

    public boolean isVisible() {
        return this.component.isVisible();
    }

    public void run() {
        while (this.adjustValue()) {
        }
        this.queueThread = null;
    }

    static boolean scroll(Table table, String string) {
        int n;
        int n2;
        if (!table.repaint) {
            return false;
        }
        TableScrollbar tableScrollbar = string.equals("PAGELEFT") || string.equals("PAGERIGHT") ? table.horiz_sb : table.vert_sb;
        if (tableScrollbar == null || !tableScrollbar.isVisible()) {
            return false;
        }
        if (string.equals("PAGELEFT") || string.equals("PAGEUP")) {
            n2 = tableScrollbar.getAdjustable().getValue() - tableScrollbar.getAdjustable().getBlockIncrement();
            n = 3;
        } else {
            n2 = tableScrollbar.getAdjustable().getValue() + tableScrollbar.getAdjustable().getBlockIncrement();
            n = 4;
        }
        tableScrollbar.getAdjustable().setValue(n2);
        n2 = tableScrollbar.getAdjustable().getValue();
        tableScrollbar.adjustmentValueChanged(new JCAdjustmentEvent(tableScrollbar.getAdjustable(), 601, n, n2));
        return true;
    }

    private void scroll_horiz(Clip clip, int n, Rectangle rectangle) {
        if (n == clip.horiz_origin) {
            return;
        }
        int n2 = n - clip.horiz_origin;
        int n3 = Math.abs(n2);
        clip.horiz_origin = n;
        JDKSupport.setBounds(rectangle, 0, 0, clip.size().width, clip.size().height);
        clip.repaint();
    }

    private void scroll_vert(Clip clip, int n, Rectangle rectangle) {
        if (n == clip.vert_origin) {
            return;
        }
        int n2 = n - clip.vert_origin;
        int n3 = Math.abs(n2);
        clip.vert_origin = n;
        JDKSupport.setBounds(rectangle, 0, 0, clip.size().width, clip.size().height);
        clip.repaint();
    }

    public void setAdjustable(JCAdjustable jCAdjustable) {
        this.adjustable.removeAdjustmentListener(this);
        this.adjustable = jCAdjustable;
        this.adjustable.addAdjustmentListener(this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.component.setBounds(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setComponent(Component component) {
        this.table.remove(this.component);
        this.component = component;
        this.table.add(this.component);
        this.table.layout();
    }

    public void setUnitIncrement(int n) {
        this.adjustable.setUnitIncrement(n);
    }

    public void setValue(int n) {
        this.adjustable.setValue(n);
        this.adjustmentValueChanged(new JCAdjustmentEvent(this.adjustable, 601, 5, n));
    }

    public void setValues(int n, int n2, int n3, int n4) {
        if (!(this.adjustable instanceof Scrollbar)) {
            this.adjustable.setMinimum(n3);
            this.adjustable.setMaximum(n4);
            this.adjustable.setVisibleAmount(n2);
            this.adjustable.setValue(n);
        } else {
            ((Scrollbar)((Object)this.adjustable)).setValues(n, n2, n3, n4);
        }
    }

    public void show(boolean bl) {
        this.component.show(bl);
    }
}

